% script to read rtf crystal file exported from Xpert
froot= 'C:\Users\andy\Documents\crystals\';
% get list of files
a = dir(strcat(froot,'*.rtf'));
fileList = {a.name}';
wavelength = 0;%0.824048991; % in angstroms, set to 0 to use file's value
thetaOffSet = -0.0010343; % offset the data to agree with the aquired data

for j = 1:length(fileList)
    data=[];
    f = strcat(froot,fileList{j});
    if exist(f,'file')
        fid = fopen(f);
    else
        error(strcat('File:',f,' not found'));
    end
    index = 1;
    while ~feof(fid)
        tline = fgets(fid);
        if strfind(tline,'Reference code:')
            refcode = tline(strfind(tline,'Reference code:')+19:end);
            refcode = regexprep(refcode,'\s',''); % remove white space
        elseif strfind(tline,'Chemical formula:')
            % remove formatting and white space from name
            chemName = regexprep(tline(strfind(tline,'Chemical formula:')+22:end),'(\\dn6|\\fs16|\\up0|\\fs20|\s)','');
        else
            s = regexprep(tline,'(\\par|\\ulnone)',''); % remove \par and or \ulnone
            C = textscan(s,'%f %f %f %f %f %f %f'); % find data table
            if sum(cellfun(@isempty,C))<4% all rows have data?
                if index > 1
                    if C{1} == (data(index-1,1)+1)
                        % check for missing hkl values
                        if isnan(C{end})
                            % this is badly hard coded!
                             disp(C);
                            C(2:end) = circshift(C(2:end),[0 3]);
                            C(cellfun(@isnan,C)) = {0}; % remove empties
                        end
                        data(index,:) = cell2mat(C); % convert to matrix
                        index = index + 1;
                        % save data in matrix
                    else
                        break
                    end
                else
                    if isempty(C{end})
                        % this is badly hard coded!
                        C(2:end) = circshift(C(2:end),[0 3]);
                        C(cellfun(@isempty,C)) = {0}; % remove empties
                    end
                    data(index,:) = cell2mat(C); % convert to matrix
                    index = index + 1;
                    % save data in matrix
                end
            end
        end
    end
    if wavelength~=0
        data(:,end-1) = asind(wavelength./(data(:,end-2)*2))*2 + thetaOffSet;
    else
        data(:,end-1) = data(:,end-1) + thetaOffSet;
    end
%     if strcmp(fileList{j},'00-039-1065.rtf')
%        pause 
%     end
    % save output file
    A = {refcode, chemName, 'label'};
    A = [A;num2cell(data(:,end-1:end)) repmat({chemName},size(data(:,end)))];
    cell2csv(strcat(froot,refcode,'_',chemName,'.csv'),A);
end