function [fitresult, gof] = createFitSmoothSRIM(xx, yym)
%CREATEFIT(XX,YYM)
%  Create a fit.
%
%  Data for 'untitled fit 1' fit:
%      X Input : xx
%      Y Output: yym
%  Output:
%      fitresult : a fit object representing the fit.
%      gof : structure with goodness-of fit info.
%
%  See also FIT, CFIT, SFIT.

%  Auto-generated by MATLAB on 12-Dec-2013 09:57:01


%% Fit: 'untitled fit 1'.
[xData, yData] = prepareCurveData( xx, yym );

% Set up fittype and options.
ft = fittype( 'smoothingspline' );
opts = fitoptions( ft );
opts.SmoothingParam = 0.999887800503895;

% Fit model to data.
[fitresult, gof] = fit( xData, yData, ft, opts );

% Plot fit with data.
figure( 'Name', 'untitled fit 1' );
h = plot( fitresult, xData, yData );
legend( h, 'yym vs. xx', 'untitled fit 1', 'Location', 'NorthEast' );
% Label axes
xlabel( 'xx' );
ylabel( 'yym' );
grid on


