% Plots solute, CrO and FeO profile plots
cr = 1;
excludeClusters = [0];
% identify ions
if(cr)
    pions = {'Fe','Cr','CrO','YO','Y','TiO','O','FeO'};
else
    pions = {'Fe','C','C','YO','Y','TiO','O','FeO'};
end
pp = length(pions);
for i = 1:length(pions)
    pp(i) =  find(strcmp(ionq,pions(i))); % position of these ions in cols
end
x=1:100;
c2 = zeros(size(ziprofile{1}));
% show one profile at a time
figure
for j=1:count
    c1 = ziprofile{j};
    solute = c1(x,pp(4))+c1(x,pp(5))+c1(x,pp(6));
    % centre the profile
    [c1] = profileCentre(solute,c1,x);
    
    % running total with exclude list
    if ~sum(j==excludeClusters)
        c2 = c2 + c1;
    end
    
    if(1) % plot figure per cluster and pause?
        subplot(1,2,1);
        plot(x*radii(j)/100, (solute)./sum(c1(x,:),2) );
        hold all
        plot(x*radii(j)/100,c1(x,pp(3))./sum(c1(x,:),2));
        plot(x*radii(j)/100,c1(x,pp(end))./sum(c1(x,:),2));
        plot(x*radii(j)/100,c1(x,pp(2))./sum(c1(x,:),2));
        ylabel('Ionic Fraction');
        legend('Solute','CrO','FeO','Cr')
        title(strcat('Cluster:',num2str(j)));
        hold off
        subplot(1,2,2); % counts
        plot(x*radii(j)/100,c1(x,pp(1)),x*radii(j)/100,c1(x,pp(2)));
        legend('Fe','Cr');
        title('Counts');
        pause
    end
end
figure
plot(x, (solute)./sum(c2(x,:),2) );
hold all
plot(x,c2(x,pp(3))./sum(c2(x,:),2));
plot(x,c2(x,pp(end))./sum(c2(x,:),2));
plot(x,c2(x,pp(2))./sum(c2(x,:),2));
ylabel('Ionic Fraction');
legend('Solute','CrO','FeO','Cr')
title(cf); % from clusterProfilerIonic
hold off