% script to give the composition as a function of range file
% AJ London Oct 2012

% need the range of rrng files:
filelist =  dir('r14_15867_FeCr_*.rrng');
fileNames = {filelist.name}';
if(0)
for rangeFile = 1:length(fileNames)
    % open file
    % rrng file format
    % [Ions]
    % Number=9
    % Ion1=Fe
    % Ion2=C
    % Ion3=N
    % ...
    % Ion9=W
    % [Ranges]
    % Number=59
    % Range1=27.9475 27.9913 Vol:0.01177 Fe:1 Color:FF00FF
    % Range2=55.8950 55.9738 Vol:0.01177 Fe:1 Color:FF00FF
    % ...
    % Range24=69.9125 69.9738 Vol:0.04060 Fe:1 O:1 Color:FF0000
    % Range59=23.9750 24.0363 Vol:0.01757 C:2 Color:660066
    %rangeFile = 'r14_15627_fwhm.rrng';
    fid = fopen(fileNames{rangeFile});
    tline = fgets(fid); % this is the first line from the rrng file, [Ions]
    if(strcmp(cellstr(tline),'[Ions]'))
        % note the cellstr removes the white space
        %keep going
        disp('Reading ions...');
    else
        disp('Error reading [Ions] tag from range file');
        return;
    end
    % get the 2nd line
    tline = fgets(fid);
    % this is the number of elements
    element_num = sscanf(tline,'Number=%f');
    disp(element_num); % debug - number of elements in ranges
    %make the elements cell array
    elements = cell(element_num,1);
    % for the next element_num lines, read the ions into the elements list
    for e = 1:element_num
        tline = fgets(fid);
        S =  textscan(tline,'Ion%*u8=%s');
        elements(e,1) = S{1};
        %disp(textscan(tline,'Ion%*u8=%s'));
    end
    % so Ion1 is elements{1} = 'Fe' for example
    % the next line should be [Ranges]
    tline = fgets(fid);
    if(strcmp(cellstr(tline),'[Ranges]'))
        % note the cellstr removes the white space
        %keep going
        disp('Read elements');
    else
        disp('Error reading elements from range file');
        return;
    end
    % get the next line
    tline = fgets(fid);
    % this is the number of ranges
    range_num = sscanf(tline,'Number=%f');
    extraCols = 5;
    ranges = cell(range_num,element_num+extraCols); % make an array to store the range details
    % 1          2        3   4      5    6    7    8        9         10    11
    % rangeStart rangeEnd vol colour newR newC newL noisePre noisePost count gausWidth[p(2)] asym[p(3)] yscale[p(4)] noiseFloor[p(5)] element1 ... elementN
    for r = 1:range_num
        tline = fgets(fid);
        C = textscan(tline,'Range%*u8=%f %f');
        ranges{r,1} = C{1};
        ranges{r,2} = C{2};
        %disp(extscan(tline,'Ion%*u8=%s'));
        % TO DO: read the rest of the range data, not just the masses
        % find the elements present in ranged ion
        for e = 1:element_num
            % this adds the number of each element present to the 'ranges' table
            % it scans for each element, e, in the line from the range file
            % then it adds on the right number of characters to move to the
            % position of the number of that element present in the ranged ion
            % The strcat...':' is so that it finds 'Co:#' not 'Color ect'
            % disp(strfind(tline,strcat(elements{e},':')));
            numOfE = str2double(tline(strfind(tline,strcat(elements{e},':'))+length(elements{e})+1));
            if(~isnan(numOfE))
                ranges{r,extraCols+e} = numOfE;
            else
                ranges{r,extraCols+e} = 0;
            end
        end
        % find ion volume information
        vol = textscan(tline,'%*s %*f Vol:%f');
        ranges{r,3} = vol{1};
        % find colour information
        color = textscan(tline(strfind(tline,'Color:'):end),'Color:%s');
        ranges(r,4) = color{1};
    end
    fclose(fid);
    allranges(:,1+(rangeFile-1)*2) = ranges(:,1);
    allranges(:,2+(rangeFile-1)*2) = ranges(:,2);
    widths(:,rangeFile) = cell2mat(ranges(:,2))-cell2mat(ranges(:,1));
end
end
results = cell(10,2*8);
for i = 1:9
    results(:,(1+2*(i-1)):(2+(2*i-2))) = rangeCorrector('C:\Users\andy\APT\r14_15867_FeCr.rrng','C:\Users\andy\APT\R14_15867 Cr01\recons\recon-v02\default\R14_15867-v02.pos',i/10);
end
results