function [ result ] = colourRanges( colourList, fileName )
%[ result ] = colourRanges( colourList, fileName{not inc rrng} )
%   This function takes a n-by-3 list of RGBs and a file name, it writes a
%   rrng type range file with each range spanning n-0.1 to n+0.1 with the
%   colour specified. This is the same behaviour as IVAS when you creat an
%   indexed cluster file.
% WARNING: To convert from RGB to HEX this function calls rgbconv which can
% be downloaded from the MATLAB exchange.

% get file name, without extension
disp(strcat('Writing new rrng file:',fileName,'.rrng'));

% open a new file: name_level.rrng
fid = fopen(strcat(fileName,'.rrng'), 'w');

if fid ==-1
    fclose(fid);
    result = -1;
    error(strcat('Cannot create new rrng file with name:',rangeFile,'.rrng'));
end

element_num =length(colourList(:,1));
fprintf(fid,'[Ions]\nNumber=%d\n',element_num);

for e=1:element_num
    fprintf(fid,'Ion%d=Cluster%d\n',e,e);
end

range_num = element_num;
fprintf(fid,'[Ranges]\nNumber=%d\n',range_num);

for r=1:range_num
    fprintf(fid,'Range%d=%6.4f %6.4f Vol:0.00000 Name:Cluster%d ',r,r-0.1,r+0.1,r);
    fprintf(fid,'Color:%s\n',rgbconv(colourList(r,:)));
end

fclose(fid);
result = 1;

end
