function [R]=colRank(M)
%[ranked]=colRank(M)
% Ranks the values in the columns of M separately and returns a matrix, R
% (ranked) the same size as M with the ranks inside it, zeros in M are
% preserved with a rank of zero.

% loop over columns
a=(1:size(M,1))'; % index/rank
R = repmat(a,1,size(M,2));
for i=1:size(M,2)
    [~,ix]=sort(M(:,i),'descend');
    R(ix,i) = a;
    R(:,i) = R(:,i).*(M(:,i)>0);
end
