function [material,irrdTemp] = codeConvert(matList)
%[material,irrdTemp] = codeConvert(matList)
% converts eg. C2 into 700, Fe-14Cr ODS
% A London specific! Oct 2013
irrdTemp = cell(length(matList),1);
material = cell(length(matList),1);

for m = 1:length(matList)
if strcmp(matList{m},'B1')
    irrdTemp{m} = '500';
    material{m} = 'Fe ODS';
elseif strcmp(matList{m},'B3')
    irrdTemp{m} = '600';
    material{m} = 'Fe ODS';
elseif strcmp(matList{m},'B2')
    irrdTemp{m} = '700';
    material{m} = 'Fe ODS';
elseif strcmp(matList{m},'C1')
    irrdTemp{m} = '500';
    material{m} = 'Fe-14Cr ODS';
elseif strcmp(matList{m},'C3')
    irrdTemp{m} = '600';
    material{m} = 'Fe-14Cr ODS';
elseif strcmp(matList{m},'C2')
    irrdTemp{m} = '700';
    material{m} = 'Fe-14Cr ODS';
elseif strcmp(matList{m},'Fe-14Cr ODS')
    irrdTemp{m} = '0';
    material{m} = 'Fe-14Cr ODS';
elseif strcmp(matList{m},'Fe ODS')
    irrdTemp{m} = '0';
    material{m} = 'Fe ODS';
elseif strcmp(matList{m},'Fe-0.3Y2O3')
    irrdTemp{m} = '0';
    material{m} = 'Fe-Y2O3';
else
    irrdTemp{m} = 'err';
    material{m} = 'err';
end
end