% cluster nmin plotter
% Use posgen to generate clusteredStats.txt file
% List of stats files
statsList = {'17183YOTiOunclusteredStats.txt' '17183YOTiOCrOunclusteredStats.txt' '17183YOTiOOYunclusteredStats.txt'};
coreList = {'YO', 'TiO','','';'YO', 'TiO', 'CrO','';'YO', 'TiO', 'O', 'Y'};
legText = {'YO,TiO','YO,TiO,CrO','YO,TiO,O,Y'};
nmin = 10;
solute = zeros(15000,3);
radii = [];
% Use clusterSizeDist to produce a table of core ion values
terplot(11); % plot tern diagram
hold on
hg = zeros(length(statsList),1);
for s = 1:length(statsList)
    [elements, countsDecomp,counts,position,ionType,rg, nTable] = clusterStatsReader(statsList{s}, coreList(s,:));
    [countsDecomp,counts,position,rg,nTable]=nminFilter (countsDecomp,counts,position,rg, nTable,nmin);
    % find Y
    A = countsDecomp(:,strcmp('Y',elements));
    B = countsDecomp(:,strcmp('Ti',elements));
    C = countsDecomp(:,strcmp('O',elements));
    M = counts(:,strcmp('Fe',ionType)) + counts(:,strcmp('Cr',ionType));
    S = A+B+C;
    A = A./S; B = B./S; C = C./S;
    x = A+B./2;
    y = B.*sqrt(3/4);
    hg(s) = scatter(x(S./(S+M)<=0.1),y(S./(S+M)<=0.1),1+20*rg(S./(S+M)<=0.1));
    solute(1:length(S),s) = S./(S+M);
    radii = [radii; rg(S./(S+M)>0.1)];
end
legend(hg,legText);
hold off