function [clusterVol,clusterVolTotal,clusterIonCount,matrixIonCount, radiusVolume]=clusterVolume(cf,rf)
%[clusterVol]=clusterVolume(clusterFile,rrngFile)
% calculate the cluster volume based on the ionic volume from the rrng file
% example files
%rf = 'C:\Users\Andy\APT\17053.rrng';
%cf ='C:\Users\Andy\APT\clusterAnalysis\R14_17053-v01.csv';
exclude = {'Fe','Cr'}; % matrix ions to exclude from ionic volume calc
% get cluster file
[celements,countsDecomp,counts,position,ionType,radii,extents,~,VExtent,Vrg,~,~,~,~,~,coreIons,n] = clusterSizeVol(cf);
% get get ranges
[element_num, range_num, elements, ranges] = rangeReader (rf);
% 3rd column is the volume
[rangeIonList,ia] = unique([makeIon(cell2mat(ranges(:,5:end)),elements) elements'],'first');
% If an molecular ion exists when a cluster search is done then the
% elements in that ion are listed separetly in the cluster.csv file
% generated by IVAS. If the elements are not ranged, eg, TiO is used but Ti
% is not ranged, then this causes issues. To get round this I add [ions elements]
% together, ie, adding all the elements in the range file to the ions
% definition. These elements don't have an ionic volume, so I set them to
% have the same volume as the first range. This won't cause problems
% because the count of these ions in the clusters will be zero.
ia(ia>size(ranges,1)) = 1;
% list of ions and volumes [volList' ranges(ia,3)]
% get order in counts matrix
[sortedClusterIons,ic]=sort(ionType);
% reorder counts using: counts(:,ic)
% volume per cluster
try
    clusterVolTotal = counts(:,ic)*cell2mat(ranges(ia,3));
catch
    sortedClusterIons
    rangeIonList
end
coreVols = cell2mat(ranges(ia,3));
for i=1:length(exclude)
    coreVols(strcmp(exclude{i},sortedClusterIons)) = 0; % set volume to 0
end
clusterVol = counts*coreVols;
clusterIonCount =  counts*(coreVols>0); % use only ions with non-sero volume
matrixIonCount = xlsread(cf,1,'C12'); % Ranged Ions (matrix)
radiusVolume = ((radii(:,4)*sqrt(5/3)).^3)*(4/3)*pi;
end