% Voltage and matrix cluster content 24/06/13 A London
% This script uses a the cluster xyz coords from a clusterData file
% exported from IVAS and the associated EPOS file to get the voltage that
% each cluster evaporated at.
% Next the script will evaluate the matrix content of the clusters.

% % Input files, these could be lists
if 0
        % clusterFile = {'R14_15065-v04_YYOTiOO_08_80.csv',...
        %     'R14_15577-v13_YYO_80range.csv',...
        %     'R14_15627-v04_YYO_80.csv',...
        %     'R14_15733-v01_YYOTiO_80.csv',...
        %     'R14_15734-v02_YYOTiOO_80_08.csv',...
        %     'R14_15783-v02_Y_YO_10_06.csv',...
        %     'R14_15867-v02_YYOTiO_80.csv',...
        %     'R14_15868-v01_YYOTiO_80.csv',...
        %     'R14_16469-v01_YYOTiO_80.csv',...
        %     'R14_17053-v01_YYOTiOO.csv',...
        %     'R14_17156-v01_YYO.csv',...
        %     'R14_17226-v01_YTiOYO.csv',...
        %     'R14_17343-v02_YTiOYOO_oxcrop.csv',...
        %     'R14_17344-v01_OYTiOYO.csv'
        %     };
        % %eposFile = {'R14_15733-v01','R14_15065-v04','R14_15734-v02','R14_15783-v02','R14_15867-v02','R14_15868-v01'}; % not-inc .epos extension
        % eposRoot = 'C:\Users\Andy\APT\epos\';
        % % get all files (doesn't check for cluster files)
        % eposFile = dir('C:\Users\Andy\APT\epos\*_Vc.mat');
        % eposFile = {eposFile.name}';
end
if 0 % low-temp irradiated data
    clusterFile = {'R14_18633-v01.csv','R14_18357-v01_YYO.csv'};
    eposRoot = 'C:\Users\Andy\APT\epos\';
    eposFile = {'R14_18633-v01','R14_18357-v01'};
end
% data files
if 1
     clusterFile = {'R14_15065-v04_YYOTiOO_08_80.csv',...
         'R14_15733-v01_YYOTiO_80.csv',...
         'R14_15783-v02_Y_YO_10_06.csv'}; % exported from IVAS .csv
     eposFile = {'R14_15065-v04','R14_15733-v01','R14_15783-v02'}; % not-inc .epos extension
     eposRoot = 'C:\Users\Andy\APT\epos\'; % where the epos files are
end
clusterRoot = 'C:\Users\Andy\APT\clusterAnalysis\';
data = cell(1);
% loop through epos file list
for f = 1:length(eposFile)
    cf = strcat(clusterRoot,clusterFile{f}); % cluster file
    
    % Read epos file
    %[x,y,z,m,tof,vdc,vp,xd,yd,dP,nm,nb]=readepos(strcat(eposRoot,eposFile{f}));
    [eposData] = readCachedEpos(strcat(eposRoot,eposFile{f}),0);
    x=eposData(:,1);y=eposData(:,2);z=eposData(:,3);m=eposData(:,4);vdc=eposData(:,6);
    clear eposData
    % Read cluster data file for all it's worth!
    [elements,countsDecomp,counts,position,ionType,radii,nTable,dmax,dbulk,derode,nmin,core,count] = clusterDataReaderDetails(cf);
    %[elements,countsDecomp,counts,position,ionType,~,~,radii,nTable,dmax,dbulk,derode,nmin,core,count] = clusterExtent(cf);
    % radii is Rg
    % We'll need the dmax later
    
    % get the voltage for each cluster individually
    voltage = zeros(count,2); % voltage and stdev per cluster
    %voltageD = cell(count,1); % detailed
    for c = 1:count
        disp(strcat(num2str(c),'/',num2str(count)));
        cx = position(c,1); % cluster x,y,z
        cy = position(c,2);
        cz = position(c,3);
        cr = radii(c); % current cluster radius
        p = (x > (cx-cr)) & (x < (cx+cr));
        p = p & (y > (cy-cr)) & (y < (cy+cr));
        p = p & (z > (cz-cr)) & (z < (cz+cr));
        voltage(c,:) = [mean(vdc(p)) std(vdc(p))];
        %voltageD{c} = vdc(p);
    end
    % assumes that 1 = Fe and 1:5 = Fe,Cr,Y,O,Ti - see ionsData.mat
    feContent = sum(countsDecomp(:,1:2),2)./sum(countsDecomp(:,1:5),2);
    data{f} = [voltage radii feContent];
    % free up some memory before next iteration
    clearvars -except data clusterFile eposFile eposRoot clusterRoot f
end