% cluster volume script
cfRoot='c:\users\andy\APT\clusterAnalysis\';
rfRoot='c:\users\andy\APT\';
% get cluster and range files from database
[d,cols]=dataBase('run>0',1);
vf = zeros(size(d,1),4);
for i=1:size(d,1)
    %get files
    cf = [cfRoot d{i,strcmp('cf',cols)}];
    rf = [rfRoot d{i,strcmp('rrng',cols)}];
    % get volume for each data set
    [clusterVol,clusterVolTotal,clusterIonCount,matrixIonCount,rVol]=clusterVolume(cf,rf);
    % compute cluster volume fraction
    vf(i,1:3) = [sum(clusterVol) sum(clusterVolTotal) sum(rVol)]./d{i,strcmp('vol',cols)};
    vf(i,4) = sum(clusterIonCount)/matrixIonCount;
end
dheaders = {'run','mat','matCode','irrdT1','irrdDpa1','irrdT2','irrdDpa2'};
export = [{'IonVolSolute','IonVol','RVol','IonFrac'}; num2cell(vf)];
for i = 1:length(dheaders)
    export = [export [dheaders(i); d(:,strcmp(dheaders{i},cols))]];
end
cell2csv('clusterVolFrac2.csv',export);