function [elements, countsDecomp,counts,position,ionType,rg, nTable] = clusterStatsReader( statsFile, coreIons )
%[elements, countsDecomp,counts,position,ionType,rg, nTable] = clusterStatsReader( clusterFile, coreIons )
%CLUSTERSTATSREADER This reads the clusterStats.txt file produced by posgen
% returns the array of elements (column headings, cell array) and
% the decomposed counts (matrix)

% import data
fid = fopen(statsFile,'r'); % open file
% Read it a line at a time
tline = fgets(fid);
% Replace tabs with commas
newStr = regexprep(tline, '\t', ',');
newStr = regexprep(newStr, '\n', ',');
% Check for duplicates
newStr = regexprep(newStr, ',,', ',');
C = textscan(newStr,'%s','Delimiter',',');
textdata = C{1}';
data = [];
% read the numeric data
while ischar(tline)
    % replace tabs with commas
    newStr = regexprep(tline, '\t', ',');
    newStr = regexprep(newStr, '\r', '');
    newStr = regexprep(newStr, '\n', '');
    % check for duplicates
    newStr = regexprep(newStr, ',,', ',');
    % Translate into numeric
    C = textscan(newStr,'%f','Delimiter',',');
    tline = fgets(fid);
    data = [data; C{1}'];
end
fclose(fid);

% textdata = headers
% data = numbers

%clusterstats = importdata(clusterFile);
ionType = textdata(1,4:(end-2));% ignors un-ranged
counts = data(:,4:(end-2));     %counts = cell2mat(counts);
position = data(:,1:3);         %position = cell2mat(position);
rg = data(:,end);               %rg = cell2mat(rg);

% Report num_clusters:
disp(strcat('Found:',num2str(length(data(:,1))),' clusters'));

% For decomposition
if(exist('ionsData.xls','file'))
    % read ionsData.xls file if present:
    % read data file
    [num_e,elements]=xlsread('ionsData.xls',1,'1:1');
    disp('Read ionsData.xls');
    %elements = transpose(elements);
    % read the rest of the file
    [~,~,all]=xlsread('ionsData.xls');
    ions = all(2:end,:); % crop the data ignoring first row
    % free memory
    clear('all');
    complete = ~sum(~ismember(ionType,ions(:,1)'));
    if ~complete
       missingMembers = find(~ismember(ionType,ions(:,1)'));
       for i = 1:length(missingMembers)
          disp(strcat('Missing ion in ionsData.xls:',ionType{missingMembers(i)}));
          disp('Please add this ion to ionsData.xls, by adding the ion in');
          disp('the left column and defining the number of elements');
          disp('present in the columns to the left (element names at top).');
          error('Please amend ionData and re-run.');
       end
    end
else
    disp('Did not find ionsData.xls, please run clusterDataMaka first');
end
column_data = cell(length(ionType),num_e);
% to do
% need to compare ionType with the first column of ions (eg to compare
% FeO with ions to get FeO 1 0 0 1 0 0 0 etc
% The line from ions needs to be copied into column_data
% then multiply counts with column_data to get decomposed counts
for i = 1:length(ionType) % loop through all the read ion types
    for ionRow = 1:length(ions) % scan ions data
        if(strcmp(ionType(i),ions(ionRow,1))) % match the iontype with a row in ions
            column_data(i,:) = ions(ionRow,2:end); % copies a line from ions
        end
    end
end

% convert to matrix
column_data = cell2mat(column_data);

% decompose counts by doing matrix muliplication
countsDecomp = counts*column_data;

nTable = zeros(length(counts(:,1)),1);
% Make a column of core ions per cluster:
for c=1:length(ionType) % loop over columns checking for coreAtoms
    %starts at 4, cause the first 3 cols are x,y,z
    for i=1:length(coreIons) % loop over each core ion
        if(strcmp(coreIons{i},ionType{c}))
            % found a match, add to total
            nTable = nTable + counts(:,c);
        end
    end
end

% column headings is just 'elements'
end