% simulate the effect of detector efficiency on cluster size measurement
clusterRadius = 1;
density = 100; % ions per nm3
samples = 10;
e = 0.5:-0.05:0.1; % detector efficiency

rg = zeros(length(e),1);
rge = zeros(length(e),1);
rz = zeros(length(e),1);
rze = zeros(length(e),1);
ez = zeros(length(e),1);
eze = zeros(length(e),1);
for i=1:length(e)
    disp(e(i));
    rg_ex = zeros(samples,1);
    rz_ex = zeros(samples,1);
    ez_ex = zeros(samples,1);
    for k = 1:samples
        [x,y,z]=randsphere(round(density*(4/3)*clusterRadius^3),clusterRadius);
        p=rand(size(x))<e(i);
        [rg_ex(k),rz_ex(k)]=radiusGyrationMassless(x(p),y(p),z(p));
        ez_ex(k) = range(z)/2;
    end
    rg(i) = mean(rg_ex); rge(i) = std(rg_ex);
    rz(i) = mean(rz_ex); rze(i) = std(rz_ex);
    ez(i) = mean(ez_ex); eze(i) = std(ez_ex);
end

errorbar(e,rg,rge)
hold all
errorbar(e,rz,rze)
errorbar(e,ez,eze)
hold off
xlabel('detector eff.');
ylabel('radius');