% cluster size simulator
%% simulates actual and observed sizes in APT

samples = 300; % how many clusters per size
plotting = 0; % plot each cluster?
sizes = (2:1:30).^3; % how many atoms total
xyNoise = 0.2; % gaussian noise in nm
zNoise = 0.1; % gaussian noise in nm
rz_ex = zeros(length(sizes),2);
rg_ex = zeros(length(sizes),2);
extent_ex = rz_ex;
extentIVAS_ex = rz_ex;
extentr_ex = rz_ex;
n_ex = rz_ex;
r_ex =rz_ex(:,1);
density = 100; % atoms/nm3
e = .37; % detector efficieny
for s = 1:length(sizes)
    r = (((sizes(s)/density)*3)/(4*pi)).^(1/3);
    disp(r);
    rz=zeros(samples,1);
    rg = zeros(samples,1);
    extent = zeros(samples,1);
    extentIVAS = zeros(samples,1);
    nr = zeros(samples,1);
    extentr = zeros(samples,1);
    for p = 1:samples
        n = sizes(s);
        [x,y,z]=randsphere(n,r); % full random sphere
        x = x + randn(size(x))*xyNoise;
        y = y + randn(size(y))*xyNoise;
        z = z + randn(size(z))*zNoise;
        
        q = rand(n,1)<e; % sampling
        
        if sum(q)
            extent(p) = range(z(q));
            tempExtent = ivasExtent([zeros(size(z(q))) zeros(size(z(q))) z(q)]);
            extentIVAS(p) = tempExtent(:,3);
            [rgt,~,~,rzt]=radiusGyration(x(q),y(q),z(q),ones(size(x(q))));
            rz(p) = rzt;
            rg(p) = rgt;
            % plot cluster
            if plotting
                plot(x(q),z(q),'bo');
                xlim([-2*r 2*r]);
                ylim([-2*r 2*r]);
                hold on
                circle(0,0,r);
                plot([min(x) max(x) nan min(x) max(x)],[mean(z(q))+tempExtent(3) mean(z(q))+tempExtent(3) nan mean(z(q))-tempExtent(3) mean(z(q))-tempExtent(3)],'r-');
                plot([min(x) max(x) nan min(x) max(x)],[min(z(q)) min(z(q)) nan max(z(q)) max(z(q))],'g-');
                hold off
                pause
            end
        else
            rz(p) = 0;
            rg(p) = 0;
            extent(p) = 0;
            extentIVAS(p) = 0;
        end
        extentr(p) = range(z); % real extent
        nr(p) = sum(q);
    end
    r_ex(s) = r; % actual radius
    rz_ex(s,:) = [mean(rz) std(rz)];
    rg_ex(s,:) = [mean(rg) std(rg)];
    extent_ex(s,:) = [mean(extent) std(extent)];
    extentIVAS_ex(s,:) = [mean(extentIVAS) std(extentIVAS)];
    extentr_ex(s,:) = [mean(extentr) std(extentr)];
    n_ex(s,:) = [mean(nr) std(nr)];
end
%% comparison plots
clf
subplot(2,1,1) 
hold all
plot(r_ex,r_ex); % perfect
errorbar(r_ex,rz_ex(:,1),rz_ex(:,2));
errorbar(r_ex,rg_ex(:,1),rg_ex(:,2));
errorbar(r_ex,extent_ex(:,1)/2,extent_ex(:,2)/2);
errorbar(r_ex,extentIVAS_ex(:,1),extentIVAS_ex(:,2));
legend('Perfect','R_z','R_g','Extent_z','Extent_z IVAS');
hold off
xlabel('Simulated Radius nm');ylabel('Measured Radius nm');
title(strcat('Variation of Measured Cluster size by Simulation, \epsilon=',num2str(e*100,'%d'),'%'))

%% variation plot
subplot(2,1,2) 
sigma_x = sqrt((1-e)*n_ex(:,1));
error_x = sigma_x./n_ex(:,1); % relative error in x
plot(extent_ex(:,1)/2,error_x.*extent_ex(:,1)/2,extent_ex(:,1)/2,extent_ex(:,2),r_ex(:,1),error_x.*r_ex(:,1),'k-.')
xlabel('Radius nm');
ylabel('Standard Deviation');
legend('Predicted from measured radius','Std. Dev. of simulation radius','Analytical solution using actual radius');

%% fitting
f = fit(r_ex,rz_ex(:,1),'poly1');
disp('R_z gradient');
disp(num2str(f.p1));

%% export data
export = [r_ex rz_ex rg_ex extent_ex/2 extentIVAS_ex];
%cell2csv('radiusSim.csv',[{'rperfect','rz','rzErr','lg','lgErr','range','rangeErr','extent','extentErr'}; export])
e2 = reshape(export(:,2:2:end),[],1);
e3 = reshape(export(:,3:2:end),[],1);
labels = {'rz','lg','range','extent'};
exportFactored = [{'x','y','err','Measure'}; num2cell(reshape(repmat(r_ex,size(labels,2),1),[],1)) num2cell(e2) num2cell(e3) reshape(repmat(labels,size(r_ex,1),1),[],1)];
%cell2csv('radiusSimNoise.csv',exportFactored);