% particle size simulator
% simulates actual and observed sizes in APT

samples = 1000; % how many clusters per size
sizes = (2:1:30).^3; % how many atoms total
rz_ex = zeros(length(sizes),2);
rg_ex = zeros(length(sizes),2);
extent_ex = rz_ex;
r_ex =rz_ex(:,1);
r_ex2 =rz_ex(:,1);
density = 20; % atoms/nm3
e = 0.37; % detector efficiency
for s = 1:length(sizes)
    r = (((sizes(s)/density)*3)/(4*pi)).^(1/3);
    rz=zeros(samples,1);
    rg = rz;
    extent = rz;
    for p = 1:samples
        n = round(sizes(s)*e);
        [x,y,z]=randsphere(n,r);
        [rgt,~,~,rzt]=radiusGyration(x,y,z);
        rz(p) = rzt;
        rg(p) = rgt;
        extent(p) = range(z);
    end
    r_ex(s) = sizes(s)^(1/3);
    r_ex2(s) = r;
    rz_ex(s,:) = [mean(rz) std(rz)];
    rg_ex(s,:) = [mean(rg) std(rg)];
    extent_ex(s,:) = [mean(extent) std(extent)];
end

clf
hold all
plot(r_ex,r_ex2); % perfect
errorbar(r_ex,rz_ex(:,1),rz_ex(:,2));
errorbar(r_ex,rg_ex(:,1),rg_ex(:,2));
errorbar(r_ex,extent_ex(:,1)/2,extent_ex(:,2)/2);
legend('Perfect','R_z','R_g','Extent_z');
hold off
xlabel('Simulated Radius nm');ylabel('Measured Radius nm');
title('Variation of Measured Cluster size by Simulation, \epsilon=37%')
% fitting
f = fit(r_ex,rz_ex(:,1),'poly1');
disp('R_z gradient');
disp(num2str(f.p1));
figure
% plot under-estimate
plot(r_ex,(r_ex-r_ex)./r_ex)
hold all
plot(r_ex,-100*((rz_ex(:,1)/0.44721)-r_ex)./r_ex)
%plot(r_ex,-100*((rz_ex(:,1))-r_ex)./r_ex)
plot(r_ex,-100*(rg_ex(:,1)-r_ex)./r_ex)
plot(r_ex,-100*((extent_ex(:,1)/2)-r_ex)./r_ex)
legend('Perfect','R_z','R_g','Extent_z');
hold off
xlabel('Simulated Radius nm');ylabel('Radius Underestimate %');
title(strcat('Measured Cluster Size Compared to Simulation, \epsilon=',num2str(e*100),'%, d=',num2str(density),'nm^{-3}'))