% Runs multiple cluster searchs of random data and returns the cluster size
% distribution in number of core atoms in the core.
% A London Nov 2013
% number of runs to perform
% WARNING! Each run may take at least 20s to run!
tic
num_runs = 20;
% List of range files:
rrngList = {'17183'};
% Get list of pos files:
[rrngFile,posList] = rpvLs(rrngList,{1});
% Set range file
rrngFile = regexprep(rrngFile{1},'.rrng','_80.rrng');

rrngFile = 'C:\Users\andy\APT\17183_80.rrng';
%posFile = 'C:\Users\andy\APT\R14_17183\recons\recon-v01\default\R14_17183-v01.pos';
posFile = 'C:\Users\andy\APT\R14_17183\recons\recon-v01\default\R14_17183-v01.matrix.pos';

% Set posgen dir
posDir = 'C:\Users\andy\APT\posgen\';
% copy rrng file to posgen dir
cpy(rrngFile,posDir);
% copy pos file to posgen dir
cpy(posFile,posDir);

% Run cluster search
% Generate clusterOps.xml file:
[~,rrngName,rrngExt]= fileparts(rrngFile);
[~,posName,posExt]= fileparts(posFile);

dselection = 0.5:0.2:1.1;
results_random_matrix = cell(size(dselection),2);
for d = 1:length(dselection)
    dmax = num2str(dselection(d));%'0.7';
    dbulk = '0'; % set to zero to skip, time saver!
    nmin = '3';
    core = {'YO' 'TiO' 'Y' 'O'};
    statsFile = strcat(rrngList{1},'YOTiOCrOclusteredStats.txt');
    disp('Generating posgen options xml file');
    posgenOptionGen('ops.xml',strcat(posName,posExt),strcat(rrngName,rrngExt),dmax,'1',dbulk,'0',nmin,core,statsFile,0,0,0,0);
    if(0) % for cluster search of real data
        % Run posgen
        disp('Running posgen');
        returncode = unix('posgen ops.xml');
        if returncode ~=0
            error('posgen died')
        end
        % get results (read statsFile)
        disp('Reading clustered stats file');
        [~, ~,~,~,~,~, clusteredN] = clusterStatsReader(statsFile, core);
    end
    xx = []; yy=[];
    unclusterResults = cell(1,num_runs);
    %figure; hold all
    for r = 1:num_runs
        % run search of random data
        statsFile = strcat(rrngList{1},'YOTiOCrOunclusteredStats.txt');
        disp('Running posgen for unclustered search');
        posgenOptionGen('ops.xml',strcat(posName,posExt),strcat(rrngName,rrngExt),dmax,'1',dbulk,'0',nmin,core,statsFile,1,0,0,0);
        % Run posgen
        disp('Running posgen');
        returncode = unix('posgen ops.xml');
        if returncode ~=0
            error('posgen died')
        end
        % get results
        disp('Reading unclustered stats file');
        [~, ~,~,~,~,~, unclusterResults{r}] = clusterStatsReader(statsFile, core);
        ux = (str2double(nmin):(max(unclusterResults{r})+1));
        [uy] = histc(unclusterResults{r},ux-.5);
        %plot(ux,uy,'x');
        % store results
        results_random_matrix{d,1}{r,1} = ux';
        results_random_matrix{d,2}{r,1} = uy;
    end
end
%set(gca,'yscale','log'); % **use log scale**
%xlabel('Core ions count');ylabel('Number of clusters');
%hold off
% plot with dmax
xd = size(results_random_matrix,1);
yd= xd;
for i = 1:size(results_random_matrix,1)
    xd{i} = vertcat(results_random_matrix{i,1}{:});
    yd{i} = vertcat(results_random_matrix{i,2}{:});
    %a = cellfun(@transpose,results_random_matrix{i,2}(:),'uni',0);
    %yd{i} = vertcat(a{:});
end
figure
loglog(xd{1},yd{1},'x')
hold all
for i = 2:length(dselection)
    loglog(xd{i},yd{i},'x')
end
hold off
% generate legend
[~,~,~,~,~,~,splitstring] = regexp(num2str(dselection,'%2.2f\t'),'\t');
legend(splitstring);
xlabel('Core ions count');ylabel('Number of clusters');
title('Cluster Size Distribution for various D_{MAX} nm')
toc