% Using a range file and pos file run a cluster search using posgen and
% then plot the resulting size distribution compared to the same cluster
% search on the randomly relabelled data set
% List of range files:
rrngList = {'17183'};
% Get list of pos files:
[rrngFile,posList] = rpvLs(rrngList,{1});
% Set range file
rrngFile = regexprep(rrngFile{1},'.rrng','_80.rrng');
% Set posgen dir
posDir = 'C:\Users\andy\APT\posgen\';
% copy rrng file to posgen dir
cpy(rrngFile,posDir);
% copy pos file to posgen dir
cpy(posList{1},posDir);

% Run cluster search
% Generate clusterOps.xml file:
[~,rrngName,rrngExt]= fileparts(rrngFile);
[~,posName,posExt]= fileparts(posList{1});
dmax = '0.7';
dbulk = '0'; % set to zero to skip, time saver!
nmin = '3';
core = {'YO' 'TiO' 'CrO'};
statsFile = strcat(rrngList{1},'YOTiOCrOclusteredStats.txt');
disp('Generating posgen options xml file');
posgenOptionGen('ops.xml',strcat(posName,posExt),strcat(rrngName,rrngExt),dmax,'1',dbulk,'0',nmin,core,statsFile,0,0,0,0);
if(0) % for cluster search of real data
    % Run posgen
    disp('Running posgen');
    returncode = unix('posgen ops.xml');
    if returncode ~=0
        error('posgen died')
    end
    % get results (read statsFile)
    disp('Reading clustered stats file');
    [~, ~,~,~,~,~, clusteredN] = clusterStatsReader(statsFile, core);
end
% run search of random data
statsFile = strcat(rrngList{1},'YOTiOCrOunclusteredStats.txt');
disp('Running posgen for unclustered search');
posgenOptionGen('ops.xml',strcat(posName,posExt),strcat(rrngName,rrngExt),dmax,'1',dbulk,'0',nmin,core,statsFile,1,0,0,0);

% Run posgen
disp('Running posgen');
returncode = unix('posgen ops.xml');
if returncode ~=0
    error('posgen died')
end
% get results
disp('Reading unclustered stats file');
[~, ~,~,~,~,~, unclusteredN] = clusterStatsReader(statsFile, core);
% plot results
cx = (str2double(nmin):(max(clusteredN)+1));
ux = (str2double(nmin):(max(unclusteredN)+1));
[cy] = histc(clusteredN,cx-.5);
[uy] = histc(unclusteredN,ux-.5);
disp('Plotting results');
plot(cx,cy,'k-',ux,uy,'r-');
xlabel('Core ions count');ylabel('Number of clusters');
% save results?