% size comparison script
% reads a set of cluster data files and returns their size as a function of
% dmax.

% get cluster files
clusterFiles = dir('C:\Users\andy\APT\clusterAnalysis\R14_17985-v01_*.csv');
clusterFiles = {clusterFiles.name}';
extentZ = zeros(length(clusterFiles),4);
dmax = zeros(length(clusterFiles),1);
countsDecomp = cell(length(clusterFiles),1);
rz = extentZ;
for i = 1:length(clusterFiles)
    % get comp, dmax and sizes for each cluster file
    [elements,countsDecomp{i},counts,position,ionType,radii,rz(i,:),extentZ(i,:),nTable,dmax(i),dbulk,derode,nmin,core,count] = clusterExtent(clusterFiles{i});
end
% plot results
subplot(1,2,1)
plot(dmax(1:end-1),rz(1:end-1,:))
legend('Cluster 1','Cluster 2','Cluster 3','Cluster 4');
xlabel('D_{max} nm');ylabel('R_z nm');
title('R_z dependence on D_{max}');
subplot(1,2,2)
plot(dmax(1:end-1),extentZ(1:end-1,:))
legend('Cluster 1','Cluster 2','Cluster 3','Cluster 4');
title('Extent_z dependence on D_{max}');
xlabel('D_{max} nm');ylabel('Extent_z nm');