function [dmax,dbulk,derode,nmin,core,count,ionNum,order,ROI] = clusterSettingsNumeric(file)
%[dmax,dbulk,derode,nmin,core,count,number of ions,korder,ROI] = clusterSettingsNumeric(file)
% Reads a IVAS generated clusterData.csv (file) and returns
% the maximum separation settings used.
% This variant returns numeric values for dmax, nmin etc and nan if a
% non-cluster file is read
% A London April 2013

% check file type
[~, ~, ext]=fileparts(file);
if ~strcmp(ext,'.csv')
   error([file ' not type .csv']); 
end
fid = fopen(file); % open file
if fid == -1
    error(strcat('Couldn`t find file:',file));
end
ROI = regexprep(fgets(fid),'(ROI,)|\n','');
tline = fgets(fid); % core ions
s = sscanf(tline,'Ion(s),%s'); % remove starting string
% check this is not empty (caused by not reading a valid cluster.csv file)
if isempty(s)
    dmax = nan; % return nan
    dbulk = nan;
    derode = nan;
    nmin = nan;
    core = nan;
    count = 0; % technically correct!
    ionNum = nan;
else
    core = textscan(s,'%s','delimiter', ','); % get cell array
    core = core{1}'; % Lists the ions
    core = core(~strcmp('',core)); % Remove any empty cells
    tline = fgets(fid); % dmax
    s = sscanf(tline,'d-max (nm),%f,');
    dmax = num2str(s);
    tline = fgets(fid); % order (unreported)
    s = sscanf(tline,'Order (ions),%f,');
    order = num2str(s);
    tline = fgets(fid); % nmin
    s = sscanf(tline,'N-min (ions),%f,');
    nmin = num2str(s);
    tline = fgets(fid); % dbulk
    s = sscanf(tline,'L (nm),%f,');
    dbulk = num2str(s);
    tline = fgets(fid); % derode
    s = sscanf(tline,'d-erosion (nm),%f,');
    derode = num2str(s);
    tline = fgets(fid); % blank line
    tline = fgets(fid); % count
    s = sscanf(tline,'Cluster Count,%f,');
    count = num2str(s);
    tline = fgets(fid); % blank line
    tline = fgets(fid); % Headers
    ionNum = length(strfind(tline,'Count'));
    % set return values
    dmax = str2double(dmax);
    dbulk = str2double(dbulk);
    derode = str2double(derode);
    nmin = str2double(nmin);
    count = str2double(count);
end
fclose('all');
end