function [dmax,dbulk,derode,nmin,core,count] = clusterSettings(file)
%function [dmax,dbulk,derode,nmin,core,count] = clusterSettings(file)
% Reads a IVAS generated clusterData.csv (file) and returns
% the maximum separation settings used
%file = 'R14_15065-v04_Y_YO_09_10.csv';
fid = fopen(file);
tline = fgets(fid);
tline = fgets(fid); % core
s = sscanf(tline,'Ion(s),%s'); % remove start
core = textscan(s,'%s','delimiter', ','); % get cell array
core = core{1}';
tline = fgets(fid); % dmax
s = sscanf(tline,'d-max (nm),%f,');
dmax = num2str(s);
tline = fgets(fid); % order (unreported)
tline = fgets(fid); % nmin
s = sscanf(tline,'N-min (ions),%f,');
nmin = num2str(s);
tline = fgets(fid); % dbulk
s = sscanf(tline,'L (nm),%f,');
dbulk = num2str(s);
tline = fgets(fid); % derode
s = sscanf(tline,'d-erosion (nm),%f,');
derode = num2str(s);
tline = fgets(fid); % blank
tline = fgets(fid); % count
s = sscanf(tline,'Cluster Count,%f,');
count = num2str(s);
fclose(fid);
end