% cluster composition profile
% This script looks at each cluster in a cluster data file (exported from
% IVAS), the accompanying pos file and rrng file and produces a line
% profile along the analysis direction (approximated to Z) or use the
% cluster file to get the xyz and then use the pulse number to get the true
% sequence of evaporation, then we can plot concentration or number of hits
% as a function of reconstructed z or of pulse number

f = 1; % this can be a loop later

% % Input files, these could be lists
% clusterFile = {'R14_15868-v01_YYOTiO_80.csv', 'R14_16915-v02_YYOTiOO.csv',  'R14_16919-v01_YOTiOCrO.csv', 'R14_15867-v02_YYOTiOO_20_08.csv','R14_15733-v01_YYOTiO_80.csv'};
% clusterRoot = 'C:\Users\Andy\APT\clusterAnalysis\';
% % rrng files
% rrngFiles = {'15868.rrng','16915_80.rrng','16919_80.rrng','15867_80.rrng','15733_80.rrng'};
% rrngFiles = strcat('C:\Users\Andy\APT\',rrngFiles);
% % epos cached files
% eposRoot = 'C:\Users\Andy\APT\epos\';
% % get file list
% eposFile = {'R14_15868-v01.epos', 'R14_16915-v02.epos', 'R14_16919-v01.epos', 'R14_15867-v02.epos','R14_15733-v01.epos'};
% % remove extension:
% eposFile = regexprep(eposFile,'.epos','');

% data files
if 0
    clusterFile = {'R14_15065-v04_YYOTiOO_08_80.csv',...
        'R14_15733-v01_YYOTiO_80.csv',...
        'R14_15783-v02_Y_YO_10_06.csv'}; % exported from IVAS .csv
    rrngFiles = {'15065_80.rrng','15733_80.rrng','15783_80.rrng'};
    rrngFiles = strcat('C:\Users\Andy\APT\',rrngFiles);
    eposFile = {'R14_15065-v04','R14_15733-v01','R14_15783-v02'}; % not-inc .epos extension
    eposRoot = 'C:\Users\Andy\APT\epos\'; % where the epos files are
    clusterPos = {'R14_15065 FeYTi_ex\recons\recon-v04\default\R14_15065-v04.cluster.pos'...
        'R14_15733 YTi04\recons\recon-v01\default\R14_15733-v01.cluster.pos'...
        'R14_15783 YTi04\recons\recon-v02\default\R14_15783-v02.cluster.pos'}; % list of *.cluster.pos files
    clusterPos = strcat('C:\Users\Andy\APT\',clusterPos);
end
if 1
    clusterFile = {'R14_15734-v02_YYOTiOO_80_08.csv',...
        'R14_15867-v02_YYOTiO_80.csv',...
        'R14_15868-v01_YYOTiO_80.csv'}; % exported from IVAS .csv
    rrngFiles = {'15734_80.rrng','15867_80.rrng','15868_80.rrng'};
    rrngFiles = strcat('C:\Users\Andy\APT\',rrngFiles);
    eposFile = {'R14_15734-v02','R14_15867-v02','R14_15868-v01'}; % not-inc .epos extension
    eposRoot = 'C:\Users\Andy\APT\epos\'; % where the epos files are
    clusterPos = {'R14_15734 Cr02\recons\recon-v02\default\R14_15734-v02.cluster.pos'...
        'R14_15867 Cr01\recons\recon-v02\default\R14_15867-v02.cluster.pos'...
        'R14_15868 Cr02\recons\recon-v01\default\R14_15868-v01.cluster.pos'}; % list of *.cluster.pos files
    clusterPos = strcat('C:\Users\Andy\APT\',clusterPos);
end
clusterRoot = 'C:\Users\Andy\APT\clusterAnalysis\';

zs = 2; % The number of rg's to go along Z for the profile
profilePoints = 100; % number of points in the profile
files = length(clusterFile);
seq = cell(1,files); % output data

for f=1:files
    % Cluster file
    cf = strcat(clusterRoot,clusterFile{f});
        % Read rrng file
    [element_num, range_num, rangeElements, ranges] = rangeReader(rrngFiles{f});
        % Read cluster data file for all it's worth!
    [elements,clusterCountsDecomp,clusterCounts,position,ionType,radii,rz,nTable,dmax,dbulk,derode,nmin,core,count] = clusterDataReaderDetailsZ(cf);
        % for the mass list counting:
    rangeTable = cell2mat(ranges(:,[1:2 5:end])); % convert to matrix
    
    if exist(strcat(eposRoot,eposFile{f},'.cluster.mat'),'file')
        % load cached epos cluster file
        load(strcat(eposRoot,eposFile{f},'.cluster.mat'));
    else
        % generate new one, this will take a while
        % Read cached epos file pos+voltage+detector information
        % eposData=[1 x, 2 y, 3 z, 4 m, 5 nm, 6 vdc,7 xd,8 yd, 9 dP, 10 tof]
        [ed] = readCachedEpos(strcat(eposRoot,eposFile{f}),2);
        pulses = cumsum(ed(:,9));
        ed = [ed(:,1:4) pulses]; % reduce epos data
        clear pulses
        % {sort for faster searching}
        disp('sorting epos data');
        tic
        [ed,~]=sortrows(ed,[3 1]);
        toc
        disp('done epos sort');
        % produce "clustered" epos file using pos file
        [x,~,z,~] = readpos(clusterPos{f});
        op = [x' z'];
        clear('x','z');
        disp('sorting pos data');
        tic
        op = sortrows(op,[2 1]);
        toc
        disp('done pos sort');
        edClr = eposCluster2(op,ed);
        save(strcat(eposRoot,eposFile{f},'.cluster.mat'),'edClr');disp('saved'); % save clusterEpos
    end
    %voltage = zeros(count,1); % mean voltage per cluster
    
    % loop through all clusters
    for c = 1:count
        disp(strcat(num2str(c),'/',num2str(count))); % progress bar
        cx = position(c,1); % cluster x,y,z
        cy = position(c,2);
        cz = position(c,3);
        cr = rz(c)*2;% 1; % fixed to 1 nm
        p = edClr(:,1)>(cx-cr) & edClr(:,1)<(cx+cr);
        p = p & edClr(:,2)>(cy-cr) & edClr(:,2)<(cy+cr);
        %cr = rz(c); % current cluster radius
        p = p & edClr(:,3)>(cz-zs*cr) & edClr(:,3)<(cz+zs*cr); % longer than the cluster
        disp(sum(p));
        %voltage(c,:) = mean(ed(p,6));
        a= [num2cell(edClr(p,5)) mz2ion(edClr(p,4),rangeTable,rangeElements)];
        
        a=a(~strcmp(a(:,2),'Fe'),:); % remove Fe
        a=a(~strcmp(a(:,2),'Cr'),:); % remove Cr
        a=a(~strcmp(a(:,2),'unranged'),:); % remove unranged
        seq{f}{c} = a;
    end
    clear('p');
end