% clusterSeqAnalyser after running clusterSequence.m run this script to
% plot the results.
evapLength = 8; % the number of ions you want to plot
recordLength = 5; % number of ions to record
dataSets = size(seq,2);

a = seq{1}{1}(1:evapLength,2);
for s = 1:dataSets
    for i=1:length(seq{s})
        if evapLength > size(seq{s}{i},1)
            b = seq{s}{i}(1:size(seq{s}{i},1),2);
            b(size(seq{s}{i},1)+1:evapLength)={'~'}; %missing data
            a = [a b]; % consistent size
        else
            a = [a seq{s}{i}(1:evapLength,2)];
        end
    end
end

cells = cell(evapLength,recordLength);
ncounts = zeros(size(cells));
for i = 1:evapLength
    [n, cellout]=cellhist(a(i,:)');
    cells(i,:) = cellout(end:-1:(end-recordLength+1));
    ncounts(i,:) = 100*n(end:-1:(end-recordLength+1))./sum(n);
    h1=subplot(evapLength,1,i);cellhist(a(i,:)');title(num2str(i));
    h = findobj(h1,'Type','patch');
    p=(i-1)/(evapLength-1);
    set(h,'FaceColor',[1 p 0],'EdgeColor','w')
end
ions = unique(cells,'stable');
bump = ions; % bump chart data
for i=1:evapLength
    for j=1:length(ions)
        bump{j,i+1} = find( strcmp(ions{j},cells(i,:)) );
        bump{j,i+1+evapLength} = ncounts(i, strcmp(ions{j},cells(i,:)) );
    end
end
% remove empty cells:
bump(cellfun(@isempty,(bump))) = {nan};
% add header
bump = ['ions' strcat('p',cellfun(@num2str,(num2cell(1:evapLength)),'uniformoutput',0)) strcat('n',cellfun(@num2str,(num2cell(1:evapLength)),'uniformoutput',0));bump];
%save using: 
cell2csv('bumpYTi.csv',bump)