% Method
% Original pos = P, CS = cluster search
% 1. CS P dmax D, nmin N = korder (~20)     = Non-Joined Pos        NJP
% 2. CS P dmax D, nmin N, korder = 1        = Joined cluster Pos    JP
% (3. CS JP_matrix dmax d, nmin n, k =1      = Small Clusters Pos    CSP)
% 4. This script (below)
% Generate new cluster results file using:
%[newcsv] = calculateNewClusterData(newFile,rrngFile,clrPos,indxClrPos,matPos,clrSettings)
% 5. use clusterFileJoin to joing the new NJP with CSP

%% Input file names:
% cluster statistics (csv) dmax D, nmin N, korder = 1
cf = 'C:\Users\andy\APT\clusterAnalysis\R14_20021-v02_140.csv';
% cluster statistics (csv) dmax D, nmin N, korder = ~20 (large)
NJP = 'C:\Users\andy\APT\clusterAnalysis\R14_20021-v02_140_order100.csv';
joinedClrPos = 'C:\Users\andy\APT\R14_20021\recons\recon-v02\default\R14_20021-v02_140.cluster.indexed.pos';
nonJoinedClrPos = 'C:\Users\andy\APT\R14_20021\recons\recon-v02\default\R14_20021-v02_order100.cluster.indexed.pos';
% output pos file:
clusterPos2 = 'C:\Users\andy\APT\R14_20021\recons\recon-v02\default\R14_20021-v02.cluster.indexed-split.pos';
% new cluster file
newClusterFile = 'C:\Users\andy\APT\clusterAnalysis\R14_20021-v02-split.csv';
%% load data
% cluster stats files
[elements,countsDecomp,counts,clrCenJP,ionType,radii,rzJP,extentZ,nTable,dmax,dbulk,derode,nmin,core,count] = clusterExtent(cf);
[elements,countsDecomp,counts,clrCenNJP,ionType,radii,rzNJP,extentZ,nTable,dmax,dbulk,derode,nmin,core,count] = clusterExtent(NJP);

% pos data
[x,y,z,m]=readpos(joinedClrPos); % load joined-cluster pos

%% 1. find the nearest JP cluster atom to each NPJ cluster COM
[JPindex] = knnsearch([x' y' z'],clrCenNJP);
% Turn the atom index into a cluster ID
JPID = m(JPindex);
%% 2. If there are duplicates then these clusters are joined
[u,ia,ic]=unique(JPID);
n=histc(JPID,u); % duplicates when n > 1
joinedClusterIDs = u(n>1);
for i = 1:length(joinedClusterIDs)
    %% 3. Isolate the joined clusters and split them using the nearest distance to
    % the NJP COMs (identified in 2)
    Jid = joinedClusterIDs(i); % joined cluster ID
    NJid = find(JPID==Jid); % cluster IDs in NJP
    tempID = knnsearch(clrCenNJP(NJid,:),[x(m==Jid)' y(m==Jid)' z(m==Jid)']);
    %4. One remains with the original ID the other gets a new ID
    newID = [Jid max(m)+(1:(length(NJid)-1))]; % set new IDs
    % amend JP cluster.indexed.pos data:
    m(m==Jid) = newID(tempID);
    % amend clrCenJP list:
    % delete old, add new:
    clrCenJP(Jid,:) = clrCenNJP(NJid(1),:);
    for j=2:length(NJid)
        clrCenJP(end+1,:) = clrCenNJP(NJid(j),:);
    end
end

savepos(x,y,z,m,clusterPos2);
%% save output files
% write new cluster.index.rrng file
writeIndexRrng(regexprep(clusterPos2,'\.pos','.rrng'),max(m));
% write new stats file
[dmax,dbulk,derode,nmin,core,count,numberofions,order,ROI] = clusterSettingsNumeric(cf);
clrSettings = {ROI;core;dmax;order;nmin;dbulk;derode};
[newcsv] = calculateNewClusterData(newClusterFile,...
    regexprep(joinedClrPos,'\.indexed\.pos','.rrng'),...
    regexprep(joinedClrPos,'\.indexed\.pos','.pos'),clusterPos2,regexprep(joinedClrPos,'\.cluster\.indexed\.pos','.matrix.pos'),clrSettings);

for i=1:1
    
    % ndiff = length(clrCenJP)-length(clrCenNJP);
% if ndiff < 0
%    error('your high order search returned more clusters than your low order one!'); 
% end
% cf could be either 
%joined clusters
%similar to cf1
%new/different compared to cf1
% This attempts to find new cluster based on distance:
%[a,d]=knnsearch(clrCenNJP,clrCenJP);
% rCutoff = max(d);
% c = sum(d>rCutoff)-ndiff; 
% while c < 0 % solve sum(d>?) - ndiff == 0
%    c = sum(d>rCutoff)-ndiff; 
%    rCutoff = rCutoff - 0.1;
%    if rCutoff<0
%        error('could not match by cut off');
%    end
% end
% disp(rCutoff);
%rCutoff = fzero(@(x) sum(d>x)-ndiff,0); % solve for r cutoff
% add new clusters to NJP positions:
%clrCenNJP = [clrCenNJP; clrCenJP(d>rCutoff,:)];
end