function [n]=clusterRrngN(file)
% [n]=clusterRrngN(file)
% reads a cluster.indexed.rrng file and returns the number of clusters
% therein
% returns n the number of clusters or 0 for failure to open
    fid = fopen(file);
    if fid == -1
        disp('**failed to open rrng file**');
        disp(file);
        n = 0; % return 0 for fail
    else
        fgets(fid); % skip first line
        s = fgets(fid);
        n = textscan(s,'Number=%d');
        n = cell2mat(n); % convert to double
        fclose(fid);
    end
end