% Colour clusters in an indexed cluster pos based on their Y fraction

% get Y fraction from a _decomp.xls file
xlsFiles = {'R14_17053-v01_YYOTiOO_decomp.xls';'R14_17343-v02_YTiOYOO_decomp.xls';'R14_17344-v01_OYTiOYO_decomp.xls'};
yfracmax = 0.3;
yfracmin = 0.05;
% read file
for i=1:length(xlsFiles)
    [num,txt,raw] =xlsread(xlsFiles{i});
    colourList = zeros(length(num(:,1)),3);
    % get the right column
    ycol = find(strcmp('Y',raw(1,:)));
    colourList(:,1) = num(:,ycol(end))>=yfracmax;
    colourList(:,2) = num(:,ycol(end))<yfracmax;
    colourList(:,3) = num(:,ycol(end))<yfracmin;
    S = textscan(xlsFiles{i},'R14_%s','delimiter','-');
    runStr = strcat(S{1}{1},'yfrac');
    result = colourRanges(colourList,runStr)
end