%clusterCompAndProfileDecompIonic
% Using cluster files (csv from IVAS), pos & range files, return a
% cluster-sensitive deconvolved ionic line profile
% Deconvolve peak overlaps on a cluster-by-cluster basis
% Use the deconvolved range table to calculate the ionic cluster profile
% Optionally decompose ionic counts into elemental ones
% zprofileCache columns:
% 1 zprofile cell(count){profilePoints-by-ions} 1 nm square, columns are ions in ionq
% 2 rangeElements {cell} of elements (str)
% 3 extentZ [double list]
% 5 ionq; % {cell} list of ions (str format) in the profile
% per-cluster decomposed data
% 4 clusterRangeTableIonic, cell(count){ranges-by-ions (in ionq)}, ionic range table
% 6 clusterRangeTablesAtomic, cell(count){ranges-by-elements (in rangeElements)}, atomic range table
% 7 clusterDecomposedCounts; % atomic composition
% 8 zprofileR cell(count){profilePoints-by-ions} rg square, columns are ions in ionq
% 9 smallList 0/1 % clusters that failed fitting
% A London Jan 2015 

%startDiary('-clusterDecompIonicNewOverlaps');
%% load pre-existing data
load('clusterDecompData2015e.mat')
%% Input files, these can be lists
% zs = 2.5; % N times extent = cluster mass spectrum sampled volume
% profilePoints = 100;
% [d,cols]=dataBase('run>0',1);
% posRoot = 'C:\Users\Andy\APT\';
% rrngFileList=strcat(posRoot,'ranges\',regexprep(d(:,strcmp(cols,'rrng')),'\.rrng','ss_80.rrng','ignorecase'));
% posFileList=strcat(d(:,strcmp(cols,'reconRoot')),d(:,strcmp(cols,'pos')));
% clusterFileList = strcat(posRoot,'clusterAnalysis\',d(:,strcmp(cols,'cf')));
% indexedPosList = regexprep(d(:,strcmp(cols,'clrIdxRrng')),'\.rrng','.pos');
% overlapsList = d(:,strcmp(cols,'overlaps'));
% clusterDecompLineprofilesName = strcat(datestr(now,30),'_clusterDecomp.mat');
% storing the data
%zprofileCache = cell(length(rrngFileList),10);
%% Load each pos file in turn:
tresult = zeros(length(rrngFileList),1);
for f=1:length(rrngFileList)
    tic
    %% decide which ions are overlapping
    overlaps = overlapsList{f}';
    %% Reading data files
    % Cluster file
    cf = clusterFileList{f};
    
    % Read rrng file
    [element_num, range_num, rangeElements, ranges] = rangeReader(rrngFileList{f});
    % for the mass list counting:
    rangeTable = cell2mat(ranges(:,[1:2 5:end])); % convert to matrix
    
    % Read cluster data file for all it's worth!
    [elements,clusterCountsDecomp,clusterCounts,position,ionType,radii,rz,extentZ,nTable,dmax,dbulk,derode,nmin,core,count] = clusterExtent(cf);

    %% Load pos data
    % Read pos file
    [x,y,z,m,nb]=readpos(posFileList{f});
    [xc,yc,zc,mc]=readpos(indexedPosList{f});
    if nb<20000000
        try
            clusterIds=clusterIndex(x,y,z,xc,yc,zc,mc);
        catch % if fails due to too little memory
            clusterIds=clusterIndexPart(x,y,z,xc,yc,zc,mc);
        end
    else
        clusterIds=clusterIndexPart(x,y,z,xc,yc,zc,mc);
    end
    clear xc yc zc mc
    %% get range counts:
    clusterRangeCounts = zeros(count,length(rangeTable(:,1))); % per cluster per range counts
    for c = 1:count
        mp = m(clusterIds==c);% selected masses
        [clusterRangeCounts(c,:),~] = massQuant(mp,rangeTable);
    end
    %% Get deconvolved range tables for each cluster:
    clear('clusterIds');

    %% Save data
    clear x y z m p nb
    zprofileCache{f,10} = clusterRangeCounts; % counts per range
    % save the current desktop incase of issues
    %save(clusterDecompLineprofilesName,'zprofileCache');
    tresult(f)=toc;
    disp(['Time remaining:' num2str(  (length(rrngFileList)-f)*mean(tresult(tresult>0))/60 ,3) ' min']);
end
%diary off