% cluster composition profile
% This script looks at each cluster in a cluster data file (exported from
% IVAS), the accompanying pos file and rrng file and produces a line
% profile along the analysis direction (approximated to Z) or use the
% cluster file to get the xyz and then use the pulse number to get the true
% sequence of evaporation, then we can plot concentration or number of hits
% as a function of reconstructed z or of pulse number

f = 8; % this can be a loop later

% Input files, these could be lists
clusterFile = {'R14_15868-v01_YYOTiO_80.csv',...
    'R14_16915-v02_YYOTiOO.csv',...
    'R14_16919-v01_YOTiOCrO.csv',...
    'R14_15867-v02_YYOTiOO_20_08.csv',...
    'R14_15733-v01_YYOTiO_80.csv',...
    'R14_15065-v04_YYOTiOO_08_80.csv',...
    'R14_15783-v02_Y_YO_10_06.csv',...
    'R14_15734-v02_YYOTiOO_80_08.csv'};
clusterRoot = 'C:\Users\Andy\APT\clusterAnalysis\';
% rrng files
rrngFiles = {'15868.rrng','16915_80.rrng','16919_80.rrng','15867_80.rrng','15733_80.rrng','15065_80.rrng','15783_80.rrng','15734_80.rrng'};
rrngFiles = strcat('C:\Users\Andy\APT\',rrngFiles);
% epos cached files
eposRoot = 'C:\Users\Andy\APT\epos\';
% get file list
eposFile = {'R14_15868-v01.epos', 'R14_16915-v02.epos', 'R14_16919-v01.epos', 'R14_15867-v02.epos','R14_15733-v01.epos','R14_15065-v04.epos','R14_15783-v02.epos','R14_15734-v02.epos'};
% remove extension:
eposFile = regexprep(eposFile,'.epos','');


zs = 5; % The number of rg's to go along Z for the profile
profilePoints = 100; % number of points in the profile
% Cluster file
cf = strcat(clusterRoot,clusterFile{f});

% Read rrng file
[element_num, range_num, rangeElements, ranges] = rangeReader(rrngFiles{f});

% Read cluster data file for all it's worth!
[elements,clusterCountsDecomp,clusterCounts,position,ionType,radii,rz,nTable,dmax,dbulk,derode,nmin,core,count] = clusterDataReaderDetailsZ(cf);

% for the mass list counting:
rangeTable = cell2mat(ranges(:,[1:2 5:end])); % convert to matrix

% Read cached epos file pos+voltage+detector information
% eposData=[1 x, 2 y, 3 z, 4 m, 5 nm, 6 vdc,7 xd,8 yd, 9 dP, 10 tof]
[ed] = readCachedEpos(strcat(eposRoot,eposFile{f}),0);

voltage = zeros(count,1); % mean voltage per cluster
zprofile = cell(count,1); % per cluster store a cell of counts and positions
% loop through all clusters
for c = 1:count
    disp(strcat(num2str(c),'/',num2str(count))); % progress bar
    cx = position(c,1); % cluster x,y,z
    cy = position(c,2);
    cz = position(c,3);
    cr = rz(c);%cr = 1; % fixed to 1 nm
    p = ed(:,1)>(cx-cr) & ed(:,1)<(cx+cr);
    p = p & ed(:,2)>(cy-cr) & ed(:,2)<(cy+cr);
    cr = rz(c); % current cluster radius
    p = p & ed(:,3)>(cz-zs*cr) & ed(:,3)<(cz+zs*cr); % longer than the cluster
    voltage(c,:) = mean(ed(p,6));
    zprofile{c} = clusterProfileIonic(ed(p,3),ed(p,4),rangeTable,profilePoints);
end

% % get counts from a list of masses and a rangeTable
% [rangeCounts, rdecompCounts] = massQuant(masses,rangeTable);

% Convert the range counts into ionic counts
clear ziprofile
ions = makeIon(rangeTable(:,3:end),rangeElements); % list of ions from rrng file
[ionq,ia,ic]= unique(ions,'stable'); % get uniquie ions
numOfIons = length(ionq);
for c = 1:count % each cluster
    for i = 1:profilePoints % each point of each cluster
        ziprofile{c}(i,:) = accumarray([ic ones(size(ic))],zprofile{c}(i,:)')';
    end
end