% Previewing of clusters from many datasets and caching of data
% cluster composition profile using pos files
% This script looks at each cluster in a cluster data file (exported from
% IVAS), the accompanying pos file and rrng file and produces a line
% profile along the analysis direction (approximated to Z) or use the
% cluster file to get the xyz and then use the pulse number to get the true
% sequence of evaporation, then we can plot concentration or number of hits
% as a function of reconstructed z or of pulse number
% A. London Nov 2013

% Input files, these could be lists
%[rrngFilesList,posFileList,clusterFileList,volList,matList]=clusterFiles({'Irrd'});
rrngFilesList = {'F:\Ceri\R14_15986\cluster2.rrng'};
posFileList = {'F:\Ceri\R14_15986\recons\recon-v01\default\R14_15986-v01.pos'};
clusterFileList = {'F:\Ceri\R14_15986\recons\recon-v01\default\R14_15986-v01 - Top-Level ROI - Cluster Analysis (YO, TiO2).csv'};
matList = {'Fe-14Cr ODS'};
zs = 2; % The number of radii to go along Z for the profile
profilePoints = 50; % number of points in the profile

% storing the data
zprofileCache = cell(length(rrngFilesList),2);

for f=1:length(rrngFilesList)
    % Cluster file
    cf = clusterFileList{f};
    
    % Read rrng file
    [element_num, range_num, rangeElements, ranges] = rangeReader(rrngFilesList{f});
    
    % Read cluster data file for all it's worth!
    [elements,clusterCountsDecomp,clusterCounts,position,ionType,radii,rz,extentZ,nTable,dmax,dbulk,derode,nmin,core,count] = clusterExtent(cf);
    
    % for the mass list counting:
    rangeTable = cell2mat(ranges(:,[1:2 5:end])); % convert to matrix
    
    % Read pos file
    [x,y,z,m,nb]=readpos(posFileList{f});
    
    zprofile = cell(count,1); % per cluster store a cell of counts and positions
    % loop through all clusters
    for c = 1:count
        disp(strcat(num2str(c),'/',num2str(count))); % progress bar
        cx = position(c,1); % cluster x,y,z
        cy = position(c,2);
        cz = position(c,3);
        cr = 1; % fixed to 1 nm
        p = x>(cx-cr) & x<(cx+cr);
        p = p & y>(cy-cr) & y<(cy+cr);
        cr = extentZ(c); % current cluster radius
        p = p & z>(cz-zs*cr) & z<(cz+zs*cr); % longer than the cluster
        zprofile{c} = clusterProfileEleNP(z(p),m(p),rangeTable,profilePoints);
    end
    clear x y z m p nb
    zprofileCache{f,1} = zprofile;
    zprofileCache{f,2} = rangeElements;
end

% now we've read all the files we can profile each cluster
excludesList = cell(length(rrngFilesList),1); % start exclude list
for f=1:length(rrngFilesList)
    zprofile = zprofileCache{f,1};
    rangeElements = zprofileCache{f,2};
    profilePlotterEleIndiv % run script to find mis-fitting clusters
end