% plots profileData produced by clusterProfileDataCompiler
% Doesn't include matrix correction
materials = unique(profileData(:,2));
x=1:100;
crBulk = 0.14;
feCol = 1;
crCol = 5;
plotColours = {'k','b','r'};
c = cell(1,length(materials)); % total counts for each alloy
c(:)={zeros(size(profileData{1,4}))}; % initialise
for j = 1:length(materials)
    for i = 1:length(profileData(:,1))
        if strcmp(materials(j),profileData(i,2))
            c{j} = c{j} + profileData{i,4};
        end
    end
end
% matrix correction to remove Cr from the cluster profiles:

clf
for j = 1:length(materials)
        % no cr
        subplot(2,3,j)
        hold on
        for i = 2:length(c{j}(1,:))-1
            plot(x,c{j}(:,i)./c{j}(:,end),plotColours{i})
        end
        hold off
        ylabel('Elemental Fraction');
        title(materials(j));
        xlabel({strcat('100 points from - ',num2str(zs),'extent_z to + ',num2str(zs),'extent_z in Z-direction')});
end