% plots profileData produced by clusterProfileDataCompiler
materials = unique(profileData(:,2));
x=1:100;
crBulk = 0.14;
feCol = 1;
crCol = 5;
plotColours = {'k','b','g','r','m'};
c = cell(1,length(materials)); % total counts for each alloy
c(:)={zeros(size(profileData{1,4}))}; % initialise
for j = 1:length(materials)
    for i = 1:length(profileData(:,1))
        if strcmp(materials(j),profileData(i,2))
            c{j} = c{j} + profileData{i,4};
        end
    end
end
% matrix correction to remove Cr from the cluster profiles:

clf
for j = 1:length(materials)
    c3 = c{j}(:,1:end-1);
    c3(:,crCol) = c{j}(:,crCol)-(c{j}(:,feCol)*crBulk);
    c3(c3<0) = 0; % remove negatives
    c3(:,feCol) = 0;
    c3(:,end+1) = sum(c3,2);
    if strcmp(materials{j}(1),'B')
        % no cr
        subplot(2,3,j)
        hold on
        for i = 2:length(c{j}(1,:))-1
            plot(x,c{j}(:,i)./c{j}(:,end),plotColours{i})
        end
        hold off
        ylabel('Elemental Fraction');
        title(materials(j));
        xlabel({strcat('100 points from - ',num2str(zs),'extent_z to + ',num2str(zs),'extent_z in Z-direction')});
    else
        subplot(2,3,j)
        hold on
        for i = 5:length(c{j}(1,:))-1
            %plot(x,c3(:,i)./c3(:,end),plotColours{i})
            plot(x,c3(:,i)./c{j}(:,end),plotColours{i})
        end
        
        i=crCol;plot(x,(c{j}(:,i)./c{j}(:,end))-crBulk+.02,'k')
        hold off
        ylabel('Matrix Corrected Elemental Fraction');
        title(materials(j));
        xlabel({strcat('100 points from - ',num2str(zs),'extent_z to + ',num2str(zs),'extent_z in Z-direction')});
    end
end