function [pfile] = clusterProfileIonic(z,m,rangeTable,n)
% Takes z-position, number of pulses and masses and returns a profile along
% the z direction, elemental counts as columns
% and n rows of z 'bins'. The data is split up into n
% bins along the z.
z0 = min(z); % z-start of the data
zs = (max(z)-z0)/n; % linear coordinate scale for z

% store results here:
pfile = zeros(n,length(rangeTable(:,1)));

for i=1:n % loop through all n bins
   z1 = z0 + zs*(i-1);   % lower bound
   z2 = z0 + zs*i;       % upper bound for z
   [pfile(i,:),~] = massQuant(m(z>z1 & z<=z2),rangeTable);
end
end