function [pfile] = clusterProfileEleNP(z,m,rangeTable,n)
% elemental comp along z for one cluster
% Takes z-position and masses and returns a profile along
% only the z direction, elemental counts as columns
% and n rows of z 'bins'. The data is split up into n
% bins along the z or pulse dimension.
z0 = min(z); % z-start of the data
zs = (max(z)-z0)/n; % linear coordinate scale for z

% store results here:
pfile = zeros(n,length(rangeTable(1,:))-2);

for i=1:n % loop through all n bins
   z1 = z0 + zs*(i-1);   % lower bound
   z2 = z0 + zs*i;       % upper bound for z
   [~,pfile(i,:)] = massQuant(m(z>z1 & z<=z2),rangeTable);
end
end