function [pfile] = clusterProfileEle(z,P,m,rangeTable,n)
% Takes z-position, number of pulses and masses and returns a profile along
% both the z direction and the pulse direction, elemental counts as columns
% and n rows of z and n rows of pulse 'bins'. The data is split up into n
% bins along the z or pulse dimension.
z0 = min(z); % z-start of the data
p0 = min(P); % P-start of the data
zs = (max(z)-z0)/n; % linear coordinate scale for z
ps = (max(P)-p0)/n; % linear coordinate scale for pulses

% store results here:
pfile = zeros(2*n,length(rangeTable(1,:))-2);
[P, pindex] = sort(P);  % sort the pulses
ms = m(pindex);         % mass list sorted by pulse number
clear pindex

for i=1:n % loop through all n bins
   z1 = z0 + zs*(i-1);   % lower bound
   z2 = z0 + zs*i;       % upper bound for z
   [~,pfile(i,:)] = massQuant(m(z>z1 & z<=z2),rangeTable);
   p1 = p0 + ps*(i-1);   % lower bound
   p2 = p0 + ps*i;       % upper bound for pulse direction
   [~,pfile(n + i,:)] = massQuant(ms(P>p1 & P<=p2),rangeTable);
end
end