%clusterProfileDecompIonicPlot after running clusterProfileDecompIonic,
%call this program to plot the peak deconvolved ionic profiles.
% A London Nov 2013

% run clusterProfileDecompIonic to generate zprofileCache first

excludeClusters = [];
crBulk = 0.11;
excludesList = cell(length(zprofileCache(:,1)),1);
for f = 1:length(zprofileCache(:,1))
    % loop through each data set
    count = length(zprofileCache{f,1}(:,1));
    zeprofile = cell(count,1);
    o = ionStr2ions(zprofileCache{f,5}); % ions string
    rangeElements = zprofileCache{f,2};
    for c = 1:count
        % loop through each cluster
        % take the ionic profiles and decompose them into elemental ones for
        % plotting and vetting:
        zeprofile{c,1} = zprofileCache{f,1}{c}*ions2ionTable(o,rangeElements);
        % this is the elemental line profile, zprofileCache{f,2} = elements
    end
    
    % elements to plot
    if strcmp(matList{f},'Fe-14Cr ODS')||strncmpi(matList{f},'C',1)
        e2p = {'Y','Ti','O','Cr'};
        plotColours = {'b','g','r','m'};
        solutep = [1,2,3]; % which of the above are clustered
    elseif strcmp(matList{f},'Fe-0.3Y2O3')
        e2p = {'Y','O'};
        plotColours = {'b','r'};
        solutep = []; % which of the above are clustered
    else
        e2p = {'Y','Ti','O'};
        plotColours = {'b','g','r'};
        solutep = [1,2,3]; % which of the above are clustered
    end
    % elements to plot positions
    e2pp = zeros(1,length(e2p));
    for i = 1:length(e2p)
        e2pp(i) = find(strcmp(rangeElements,e2p{i}));
    end
    
    
    % all counts:
    c1 = zeros(size(zeprofile{1})); % total counts
    result = zeros(count,1);
    for j=1:count
        c2 = zeprofile{j};
        solute = sum(zeprofile{j}(x,e2pp(solutep)),2);
        c2 = profileCentre(solute,c2,x);
        % check if it is roughly the right shape and skip vetting if it is
        [~,r]=gfit(x,solute);
        result(j) = r;
        if r>1
            % blindly accept and move to next one
            c1 = c1 + c2;
        else
            % check cluster manually
            zcounts = sum(c2(x,:),2);
            
            plot(x,c2(x,e2pp(1))./zcounts,plotColours{1});
            hold on
            for i = 2:length(e2p)
                plot(x,c2(x,e2pp(i))./zcounts,plotColours{i});
            end
            hold off
            legend(e2p);
            xlabel({strcat('100 points from - ',num2str(zs),'extent_z to + ',num2str(zs),'extent_z in Z-direction')});
            ylabel({'Elemental Fraction'});
            runNo = regexprep(rrngFileList{f},'C:\\Users\\Andy\\APT\\','');
            runNo = regexprep(runNo,'.rrng','');
            title(strcat(runNo,': Cluster:',num2str(j),'/',num2str(count)));
            
            reply = input('Do you want include? Y/N [Y]: ', 's');
            if isempty(reply)
                reply = 'Y';
            end
            if strcmp(reply,'Y')
                disp(strcat('accepted cluster ',num2str(j)));
                if ~sum(j==excludeClusters)
                    c1 = c1 + c2;
                end
            else
                excludesList{f} = [excludesList{f} j];
            end
        end
    end
    disp(result);
    
    % total percentage final plot
    zcounts = sum(c1(x,:),2);
    i=1;plot(x,c1(x,e2pp(i))./zcounts,plotColours{i});
    hold on
    for i = 2:length(e2p)
        plot(x,c1(x,e2pp(i))./zcounts,plotColours{i});
    end
    hold off
    legend(e2p);
    xlabel({strcat('100 points from - ',num2str(zs),'r_z to + ',num2str(zs),'r_z in Z-direction')});
    ylabel({'Elemental Fraction'});
    title(strcat(runNo,': Total Elemental Fraction'));
    disp('****** CONTINUE? ********');
    pause
end