%clusterProfileDecompIonic
% Using cluster files (csv from IVAS), pos & range files, return a
% cluster-sensitive deconvolved ionic line profile
% Deconvolve peak overlaps on a cluster-by-cluster basis
% Use the deconvolved range table to calculate the ionic cluster profile
% Optionally decompose ionic counts into elemental ones

%% Input files, these can be lists
zs = 2; % N times extent = cluster mass spectrum sampled volume
profilePoints = 100;
%opts = {'Yex'};
opts = {'UnirrdCr'};
opts = {'UnirrdYTi'};
opts = {'C010'};
[rrngFileList,posFileList,clusterFileList,volList,matList]=clusterFiles(opts);
posRoot = 'C:\Users\Andy\APT\';

% remove extension:
posFile = regexprep(posFileList,'.pos','');

% For peak deconvolution, does it have Cr ions?
crList = strncmpi(matList,'C',1) | strncmpi(matList,'Fe-14Cr',7);

% storing the data
zprofileCache = cell(length(rrngFileList),4);
%% Load each pos file in turn:
for f=1:length(rrngFileList)
    %% does this analysis have Cr in it or not?
    if crList(f) 
        overlaps = cell(1,4);
        overlaps{1} = {{1,'C',2},{2,'Ti'}};
        overlaps{2} = {{2,'Ti','O'} {1,'O',2} {2,'Cr','O'} {3,'Y','O'}};
        overlaps{3} = {{2,'Fe'} {2,'Cr'}};
        overlaps{4} = {{1,'Ti','O'} {2,'Fe',2,'O'} {1,'Cr','N'} {1,'Cr','O'} {1,'Fe','N'} {1,'Fe','O'}};
    else
        overlaps = cell(1,3);
        overlaps{1} = {{1,'C',2},{2,'Ti'}};
        overlaps{2} = {{2,'Ti','O'} {1,'O',2}};
        overlaps{3} = {{1,'Ti','O'} {2,'Fe',2,'O'} {1,'Fe','N'} {1,'Fe','O'}};
    end
    %% Reading data files
    % Cluster file
    cf = clusterFileList{f};
    
    % Read rrng file
    [element_num, range_num, rangeElements, ranges] = rangeReader(rrngFileList{f});
    
    % Read cluster data file for all it's worth!
    [elements,clusterCountsDecomp,clusterCounts,position,ionType,radii,rz,extentZ,nTable,dmax,dbulk,derode,nmin,core,count] = clusterExtent(cf);
    
    % for the mass list counting:
    rangeTable = cell2mat(ranges(:,[1:2 5:end])); % convert to matrix
    %% Peak overlap stuff
    % For peak deconvolution
    overlapY = cell(size(overlaps));
    overlapTable = cell(size(overlaps)); % a rangeTable like entry for the overlaping ion data
    
    overlap_num = length(overlaps);
    for o = 1:overlap_num
        overlapY{o} = peakHeights(overlaps{o});
        overlapTable{o} = ions2ionTable(overlaps{o},rangeElements);
    end
    %% Load pos data
    % Read pos file
    [x,y,z,m,nb]=readpos(posFileList{f});
    %% Get deconvolved range tables for each cluster:
    [clusterRangeTableIonic,ionq,~] = clusterDecompTablesIonic(x,y,z,m,position,extentZ,rangeTable,rangeElements,overlapY,overlapTable,zs);
    %% Initialise vars
    zprofile = cell(count,1); % per cluster store a cell of counts and positions
    %% loop through all clusters of this {f} analysis and make *profile*
    for c = 1:count
        disp(strcat(num2str(c),'/',num2str(count))); % progress bar
        cx = position(c,1); % cluster x,y,z
        cy = position(c,2);
        cz = position(c,3);
        cr = 1; % fixed to 1 nm
        p = x>(cx-cr) & x<(cx+cr);
        p = p & y>(cy-cr) & y<(cy+cr);
        cr = extentZ(c); % current cluster radius
        p = p & z>(cz-zs*cr) & z<(cz+zs*cr); % longer than the cluster
        zprofile{c} = clusterProfileEleNP(z(p),m(p),clusterRangeTableIonic{c},profilePoints);
    end
    %% Save data
    clear x y z m p nb
    zprofileCache{f,1} = zprofile;
    zprofileCache{f,2} = rangeElements;
    zprofileCache{f,3} = extentZ;
    zprofileCache{f,4} = clusterRangeTableIonic;
    zprofileCache{f,5} = ionq; % list of ions in the profile
end