% compile lots of line profiles together into one big data file
%e2p = {'Fe','Y','Ti','O','Cr'};
%e2p = {'Fe','Y','YO','O','O2','FeO'}; % Yex
%e2p = {'Fe','Y','YO','TiO','O','O2','FeO'};    % YTi
e2p = {'Fe','Cr','Y','YO','TiO','Ti','O','O2','FeO','CrO'}; % Cr
elemental = 0; % 0 for ionic, 1 for elemental
% get the elements that are included in the ions to be plotted
[ionTable,plottedElements] = ions2ionTable(ionStr2ions(e2p));

totalClusterCount = 0;
for i = 1:size(zprofileCache,1)
    totalClusterCount = totalClusterCount + length(zprofileCache{i}) - length(excludesList{i});
end

profileData = cell(totalClusterCount,5);
%profileData =  ionic profiles, elements, radii, rangeTables, ions, elemental profiles
pindex = 1;
for i = 1:size(zprofileCache,1)
    numc = size(zprofileCache{i},1) - length(excludesList{i});
    runNo = regexprep(rrngFileList{i},'C:\\Users\\Andy\\APT\\','');
    runNo = regexprep(runNo,'.rrng','');
    profileData(pindex:pindex+numc-1,1) = {runNo}; % run number
    profileData(pindex:pindex+numc-1,2) = matList(i); % mat
    %get radius
    [~,~,~,~,~,~,~,extentZ,~,~,~,~,~,~,~] = clusterExtent(clusterFileList{i});
    p = zeros(1,length(extentZ)); % which clusters to include?
    p(excludesList{i}) = 1;
    profileData(pindex:pindex+numc-1,3) = num2cell(extentZ(~p));% radius
    % need the approiate elements
    e2pp = zeros(1,length(e2p));
    for e = 1:length(e2pp)
        if elemental
            ep = find(strcmp(zprofileCache{i,2},e2p{e})); % 2 for elemental, 5 for ionic
        else
            ep = find(strcmp(zprofileCache{i,5},e2p{e})); % 2 for elemental, 5 for ionic
        end
        if isempty(ep)
            e2pp(e) = 0;
        else
            e2pp(e) = ep;
        end
    end
    profiles = zprofileCache{i,1}(~p); % list of line profs for this run
    for j = 1:length(profiles)
        temp = zeros(length(profiles{j}(:,1)),length(e2pp)+1);
        for k = 1:length(e2pp)
            if e2pp(k) % skip missing elements (ie they are all zero)
            temp(:,k) = profiles{j}(:,e2pp(k));
            end
        end
        temp(:,end) = sum(profiles{j},2);
        profileData{pindex-1+j,4} = temp;
        % elemental comp, for when reported the ionic comp.
        if ~elemental
            temp = zeros(length(profiles{j}(:,1)),length(plottedElements)+1);
            
            [ionTable,ele] = ions2ionTable(ionStr2ions(zprofileCache{i,5}));
            eprof = profiles{j}*ionTable; % elemental profile (not ordered)
            for k = 1:length(plottedElements)
                temp(:,k) = eprof(:,strcmp(plottedElements{k},ele));
            end
            
            temp(:,end) = sum(eprof,2);
            profileData{pindex-1+j,5} = temp;
        end
    end
    
    pindex = pindex + numc;
end

% for plotting see script: 
% profileIonicPlotterSpec