% even more simple cluster peak deconvolution
% This is a test for a specific run ID (range number 19633)
% See clusterMassSpec3 for a more general script
%% Input files, these can be lists
rangeFileList = {'16933.rrng','16933_80.rrng','16933_80_80.rrng','16933_80_80.rrng','16933_80_80.rrng'};
posFileList = {'C:\Users\Andy\APT\R14_16933\recons\recon-v01\default\R14_16933-v01.pos'};
posFileList(2:5) = posFileList(1);
clusterFileList = {'C:\Users\Andy\APT\clusterAnalysis\R14_16933-v01_YOYOTiOCrO.csv'};
clusterFileList(2:5) = clusterFileList(1);
posRoot = 'C:\Users\Andy\APT\';
rangeFileList = strcat(posRoot,rangeFileList);


% remove extension:
posFile = regexprep(posFileList,'.pos','');

% For peak deconvolution
overlaps = cell(1);
overlaps{1} = {{2,'Fe'} {2,'Cr'}};

[counts,elements,extentZ,positions] = clusterDecomp(rangeFileList(1:3),posFileList(1:3),clusterFileList(1:3),overlaps);

% no overlaps
overlaps = cell(1,3);
overlaps{1} = {{2,'Ti','O'} {1,'O',2} {2,'Cr','O'} {3,'Y','O'}};
overlaps{2} = {{2,'Fe'} {2,'Cr'}};
overlaps{3} = {{1,'Ti','O'} {2,'Fe',2,'O'} {1,'Cr','N'} {1,'Cr','O'} {1,'Fe','N'} {1,'Fe','O'}};

[counts(4),elements(4),extentZ(4),positions(4)] = clusterDecompBulk(rangeFileList(4),posFileList(4),clusterFileList(4),overlaps);
[counts(5),elements(5),extentZ(5),positions(5)] = clusterDecomp(rangeFileList(5),posFileList(5),clusterFileList(5),overlaps);

xx = cell(1,length(clusterFileList));
yy= xx;
r = xx;
%clusterPosPlot
for i = 1:length(clusterFileList)
    y = counts{i}(:,strcmp(elements{i},'Y'));
    ti = counts{i}(:,strcmp(elements{i},'Ti'));
    o = counts{i}(:,strcmp(elements{i},'O'));
    r{i} = extentZ{i};
    figure
    [h,xx{i},yy{i}] = terPlotYTiO(y,ti,o,extentZ{i});
    %saveas(h,strcat('CPOSt_',name,'.png')); % save image
end