% per-cluster mass-spectra peak deconvolution, with reported peak
% compositions
%% Input files, these can be lists
%opts = {'forPhil'};
%[rangeFileList,posFileList,clusterFileList]=clusterFiles(opts);
rangeFileList = {'C:\Users\Andy\APT\15065_90.rrng'};
posFileList = {'C:\Users\Andy\APT\R14_15065 FeYTi_ex\recons\recon-v04\default\R14_15065-v04.cluster.pos'};
posRoot = 'C:\Users\Andy\APT\';
clusterFileList= {'C:\Users\Andy\APT\clusterAnalysis\R14_15065-v04_Y_YO_09_10.csv'};
cr = 0; % is there Cr?
% remove extension:
posFile = regexprep(posFileList,'.pos','');

% For peak deconvolution
if cr
    overlaps = cell(1,4);
    overlaps{1} = {{1,'C',2},{2,'Ti'}};
    overlaps{2} = {{2,'Ti','O'} {1,'O',2} {2,'Cr','N'} {2,'Cr','O'} {3,'Y','O'}};
    overlaps{3} = {{2,'Fe'} {2,'Cr'}};
    overlaps{4} = {{1,'Ti','O'} {2,'Fe',2,'O'} {1,'Cr','N'} {1,'Cr','O'} {1,'Fe','N'} {1,'Fe','O'}};
else
    overlaps = cell(1,3);
    overlaps{1} = {{1,'C',2},{2,'Ti'}};
    overlaps{2} = {{2,'Ti','O'} {1,'O',2}};
    overlaps{3} = {{1,'Ti','O'} {2,'Fe',2,'O'} {1,'Fe','N'} {1,'Fe','O'}};
end

[counts,elements,extentZ,positions,~,~,rangeCounts,rangeTables] = clusterDecomp(rangeFileList,posFileList,clusterFileList,overlaps);

%clusterPosPlot
for i = 1:length(clusterFileList)
    y = counts{i}(:,strcmp(elements{i},'Y'));
    ti = counts{i}(:,strcmp(elements{i},'Ti'));
    o = counts{i}(:,strcmp(elements{i},'O'));
    figure
    h=scatter3(positions{i}(:,1),positions{i}(:,2),-1*positions{i}(:,3),(extentZ{i}*2).^2,clusterColour([y o ti]),'filled');
    axis equal
    % get run number from rrng file name
    [pathstr, name, ext] = fileparts(rangeFileList{i});
    title(name); % set title to run number
    saveas(h,strcat('pCPOS_',name,'.png')); % save image
    figure
    h = terPlotYTiO(y,ti,o,extentZ{i});
    saveas(h,strcat('pCPOSt_',name,'.png')); % save image
end