% cluster composition from a mass spectrum
% This script looks at each cluster in a cluster data file (exported from
% IVAS), the accompanying pos file and rrng file and produces a mass spec
% which can be used for decomposition of the peaks within.
% A. London Sept 2013

%% Input files, these can be lists
opts = {'B2 unirrd'};
[rangeFileList,posFileList,clusterFileList]=clusterFiles(opts);
posRoot = 'C:\Users\Andy\APT\';

% remove extension:
posFile = regexprep(posFileList,'.pos','');

%% Initialise vars
for f=1:length(clusterFileList)
    figure % new figure
    %f = 1; % this can be a loop later
    zs = 1; % The number of rg's to go along XYZ for the cube ROI
    % Cluster file
    cf = clusterFileList{f};
    %% Read rrng file
    [element_num, range_num, rangeElements, ranges] = rangeReader(strcat(regexprep(rangeFileList{f},'.rrng',''),'_80.rrng'));
    % for the mass list counting:
    rangeTable = cell2mat(ranges(:,[1:2 5:end])); % convert to matrix
    
    %% Peak overlap stuff
    % For peak deconvolution
    overlaps{1} = {{2,'Ti','O'} {1,'O',2} {2,'Cr','O'}};
    overlaps{2} = {{1,'Ti','O'} {2,'Fe',2,'O'} {1,'Cr','N'} {1,'Cr','O'} {1,'Fe','N'} {1,'Fe','O'}};
    overlapY = cell(size(overlaps));
    overlapTable = cell(size(overlaps)); % a rangeTable like entry for the overlaping ion data
    
    overlap_num = length(overlaps);
    for o = 1:overlap_num
        overlapY{o} = peakHeights(overlaps{o});
        overlapTable{o} = ions2ionTable(overlaps{o},rangeElements);
    end
    %% Read cluster data file for all it's worth!
    [elements,clusterCountsDecomp,clusterCounts,position,ionType,radii,rz,extentZ,nTable,dmax,dbulk,derode,nmin,core,count] = clusterExtent(cf);
    
    %% Read pos file
    [x,y,z,m]=readpos(posFile{f});
    
    %% Initialise vars
    cubeCounts = zeros(count,length(rangeElements)); % per cluster store decomp'd counts
    cubeRangeCounts = zeros(count,length(ranges(:,1))); % per cluster per range counts
    cubeCountsDecomp = cubeCounts;
    smallClusterM = []; % sum of the small clusters' mass spectra
    smallList = zeros(count,1);
    %% loop through all clusters
    for c = 1:count
        disp(strcat(num2str(c),'/',num2str(count))); % progress bar
        rangeTableDecomp = rangeTable; % rangeTable for this cluster
        cx = position(c,1); % cluster x,y,z
        cy = position(c,2);
        cz = position(c,3);
        a = zs*extentZ(c); % scaled current cluster radius
        p1 = z>(cz-a);
        p2 = z<(cz+a);
        p3 = x>(cx-a);
        p4 = x<(cx+a);
        p5 = y>(cy-a);
        p6 = y<(cy+a);
        mp = m(p1&p2&p3&p4&p5&p6); % selected masses
        % get mass spectrum of this cluster
        [cubeRangeCounts(c,:),cubeCounts(c,:)] = massQuant(mp,rangeTable);
        for o = 1:overlap_num
            % get ionicRangePercentages
            [ionicRangeComp,failedIons] = peakDecompFail(mp,overlapY{o});
            ionStatus = failedIons;
            % get for errors
            if sum(failedIons)>0
                disp(strcat('Removing ion:',num2str(find(failedIons))));
                %[ionicRangeComp,failedIons] = peakDecompPlot(mp,overlapY{o}(:,logical([1 ~failedIons'])),overlaps{o}(~failedIons));
                [ionicRangeComp,failedIons] = peakDecompFail(mp,overlapY{o}(:,logical([1 ~failedIons'])));
            end          
            % detect failure
            if sum(ionicRangeComp(:)) == 0 || sum(isnan(ionicRangeComp(:)))
%                 if sum(ionicRangeComp(:)) == 0
%                     disp('ionicRange = 0');
%                 elseif sum(isnan(ionicRangeComp(:)))
%                     disp('ionicRange isNaN');
%                 end
                % do not change compTable or copy into rangeTable
                % add masses to small cluster M
                smallClusterM = [smallClusterM mp];
                smallList(c) = 1;
                % need to do this once per cluster though...
                % we can decompose these small clusters later
                disp(strcat('Cluster:',num2str(c),' added to smallClusterM'));
                rangeTableDecomp = rangeTable; % reset for this cluster
                break
            else
                % find the appropriate ranges
                compTable = ionicRangeComp * overlapTable{o}(logical(~ionStatus'),:);
                %compTable = ionicRangeComp * overlapTable{o};
                %hist(mp,(overlapY{o}(1,1)-1):0.02:(overlapY{o}(end,1)+1));
                %pause
                for t = 1:length(overlapY{o}(:,1))
                    tr = overlapY{o}(t,1);
                    yr = find(tr>rangeTable(:,1) & tr<rangeTable(:,2)); % range to replace
                    if length(yr)>1
                        error(strcat('Range overlap detected at ',num2str(tr),' with ranges:',num2str(yr)));
                    elseif isempty(yr)
                        %disp(strcat('No range containing ', num2str(tr), ' found'));
                    else
                        % copy in the row from the matrix of ionic percentages v elements
                        rangeTableDecomp(yr,3:end) = compTable(t,:);
                    end
%                     % DEBUGGING display code:
%                     if tr>31.98 && tr<31.99
%                         % disp TiO%
%                         %disp(strcat('TiO% in 32 peak:',num2str(compTable(t,strcmp('Ti',rangeElements))*100),'%'));
%                         test(c,1) = compTable(t,strcmp('Ti',rangeElements))*100;
%                         if compTable(t,strcmp('Ti',rangeElements))<0
%                             error('Negative TiO%!');
%                         end
%                     elseif tr>63.94 && tr<63.95
%                         % disp TiO%
%                         %disp(strcat('TiO% in 64 peak:',num2str(compTable(t,strcmp('Ti',rangeElements))*100),'%'));
%                         test(c,2) = compTable(t,strcmp('Ti',rangeElements))*100;
%                     end
                end
            end
        end
        % ready to do the new decomp
        if ~smallList(c)
            cubeCountsDecomp(c,:) = cubeRangeCounts(c,:)*(rangeTableDecomp(:,3:end));
        end
    end
    %% Decomp small clusters
    if sum(smallList) % are there small clusters?
        disp('Decomp small clusters'); % progress alert
        rangeTableDecomp = rangeTable; % rangeTable for this cluster
        mp = smallClusterM;
        for o = 1:overlap_num
            % get ionicRangePercentages
            %ionStatus = zeros(length(overlaps),1);
            [ionicRangeComp,failedIons] = peakDecompFail(mp,overlapY{o});
            ionStatus = failedIons;
            % get for errors
            if sum(failedIons)>0
                disp(strcat('Removing ion:',num2str(find(failedIons))));
                %[ionicRangeComp,failedIons] = peakDecompPlot(mp,overlapY{o}(:,logical([1 ~failedIons'])),overlaps{o}(~failedIons));
                [ionicRangeComp,failedIons] = peakDecompFail(mp,overlapY{o}(:,logical([1 ~failedIons'])));
            end
            % check for failure again?
            compTable = ionicRangeComp * overlapTable{o}(logical(~ionStatus'),:);
            if sum(ionicRangeComp(:)) ~=0
            % find the appropriate ranges
            for t = 1:length(overlapY{o}(:,1))
                tr = overlapY{o}(t,1);
                yr = find(tr>rangeTable(:,1) & tr<rangeTable(:,2)); % range to replace
                if length(yr)>1
                    error(strcat('Range overlap detected at ',num2str(tr),' with ranges:',num2str(yr)));
                elseif isempty(yr)
                    disp(strcat('No range containing ', num2str(tr), ' found'));
                else
                    % copy in row from compTable
                    rangeTableDecomp(yr,3:end) = compTable(t,:);
                end
            end
            end
        end
        % decompose each small cluster
        for c = 1:count
            if smallList(c)
                % small cluster found
                cubeCountsDecomp(c,:) = cubeRangeCounts(c,:)*(rangeTableDecomp(:,3:end));
            end
        end
    end
    %% do another decomposition and generate the ternary data
    cubeCounts2 = cubeCountsDecomp;%cubeRangeCounts*rangeTable(:,3:end);
    cubeCounts3{f} = cubeCounts2;
    clusterCountsTot{f} = clusterCountsDecomp;
    terXY1 = [];
    terXY2 = [];
    %% original data
    t = sum(clusterCountsDecomp(:,[find(strcmp(elements,'Y')) find(strcmp(elements,'Ti')) find(strcmp(elements,'O'))]),2);
    terXY1(:,1) = clusterCountsDecomp(:,strcmp(elements,'Y'))./t + 0.5*clusterCountsDecomp(:,strcmp(elements,'Ti'))./t;
    terXY1(:,2) = 0.866*clusterCountsDecomp(:,strcmp(elements,'Ti'))./t;
    subplot(1,2,1);
    terplot(6);
    hold on
    title(strcat('Original data:',rangeList{f}));
    scatter(terXY1(:,1),terXY1(:,2),(radii*2).^2,clusterColour(clusterCountsDecomp(:,[find(strcmp(elements,'Y')) find(strcmp(elements,'O')) find(strcmp(elements,'Ti'))]))); % original data
    hold off
    
    %% deconvolved data
    subplot(1,2,2);
    terplot(6);
    hold on
    title('Decomposed Composition');
    t = sum(cubeCounts2(:,[find(strcmp(rangeElements,'Y')) find(strcmp(rangeElements,'Ti')) find(strcmp(rangeElements,'O'))]),2);
    terXY2(:,1) = cubeCounts2(:,strcmp(rangeElements,'Y'))./t + 0.5*cubeCounts2(:,strcmp(rangeElements,'Ti'))./t;
    terXY2(:,2) = 0.866*cubeCounts2(:,strcmp(rangeElements,'Ti'))./t;
    scatter(terXY2(:,1),terXY2(:,2),(radii*2).^2,clusterColour(cubeCounts2(:,[find(strcmp(rangeElements,'Y')) find(strcmp(rangeElements,'O')) find(strcmp(rangeElements,'Ti'))])),'filled'); % new data
    spacing = 0.05;
    text(0.5,-spacing,'Y fraction','Rotation',0,'HorizontalAlignment','center');
    text((.75)+spacing,(.866/2),'Ti fraction','Rotation',-60,'HorizontalAlignment','center');
    text((.25)-spacing,(.866/2),'O fraction','Rotation',60,'HorizontalAlignment','center');
    hold off
end