% clusterIndivExport2 using a cluster index pos file export a specific
% cluster from a file

defaultPath = 'C:\users\andy\APT';
reopen = 0; % 0/1 repoen last used files (if loaded already)

if ~reopen
    disp('open cluster indexed pos file');
    [icpFile,icpPath] = uigetfile('.cluster.indexed.pos','Open cluster indexed pos file',defaultPath);
    disp('open pos file');
    [cpFile,cpPath] = uigetfile('.pos','Open pos file',defaultPath);
end

[x,y,z,m,np]=readpos([cpPath cpFile]);
% load indexed pos
[xc,yc,zc,mc,npc]=readpos([icpPath icpFile]);
clusterIds = clusterIndex(x,y,z,xc,yc,zc,mc);

numberOfClusters = max(clusterIds);

% which cluster?
c = input('Reuse which settings for the header?');
if ~isnumeric(c)
    c = 1; % check input
    disp('Using cluster 1');
elseif c>numberOfClusters || c<1
    c = 1;
    disp('Using cluster 1');
end
p = (clusterIds==c);
xi = x(p);
yi = y(p);
zi = z(p);
mi = m(p);
clear x y z m xc yc zc mc p
newFileName = [cpPath regexprep(cpFile,'.pos','-c') num2str(c) '.pos'];
savepos(xi',yi',zi',mi',newFileName);