% export region around a cluster as a pos file

%% Input files, these can be lists
zs = 1; % N times extent = cluster mass spectrum sampled volume
f=1;
c=86;
profilePoints = 100;
opts = {'Unirrd'};
[rrngFileList,posFileList,clusterFileList,volList,matList]=clusterFiles(opts);
posRoot = 'C:\Users\Andy\APT\';

% remove extension:
posFile = regexprep(posFileList,'.pos','');

% For peak deconvolution, does it have Cr ions?
crList = strncmpi(matList,'C',1) | strncmpi(matList,'Fe-14Cr',7);

% storing the data
zprofileCache = cell(length(rrngFileList),4);
%% Load each pos file in turn:
%% does this analysis have Cr in it or not?
if crList(f)
    overlaps = cell(1,3);
    overlaps{1} = {{2,'Ti','O'} {1,'O',2} {2,'Cr','O'}};
    overlaps{2} = {{2,'Fe'} {2,'Cr'}};
    overlaps{3} = {{1,'Ti','O'} {2,'Fe',2,'O'} {1,'Cr','N'} {1,'Cr','O'} {1,'Fe','N'} {1,'Fe','O'}};
else
    overlaps = cell(1,2);
    overlaps{1} = {{2,'Ti','O'} {1,'O',2}};
    overlaps{2} = {{1,'Ti','O'} {2,'Fe',2,'O'} {1,'Fe','N'} {1,'Fe','O'}};
end
%% Reading data files
% Cluster file
cf = clusterFileList{f};

% Read rrng file
[element_num, range_num, rangeElements, ranges] = rangeReader(rrngFileList{f});

% Read cluster data file for all it's worth!
[elements,clusterCountsDecomp,clusterCounts,position,ionType,radii,rz,extentZ,nTable,dmax,dbulk,derode,nmin,core,count] = clusterExtent(cf);

% for the mass list counting:
rangeTable = cell2mat(ranges(:,[1:2 5:end])); % convert to matrix
%% Peak overlap stuff
% For peak deconvolution
overlapY = cell(size(overlaps));
overlapTable = cell(size(overlaps)); % a rangeTable like entry for the overlaping ion data

overlap_num = length(overlaps);
for o = 1:overlap_num
    overlapY{o} = peakHeights(overlaps{o});
    overlapTable{o} = ions2ionTable(overlaps{o},rangeElements);
end
%% Load pos data
% Read pos file
[x,y,z,m,nb]=readpos(posFileList{f});
%% Get deconvolved range tables for each cluster:
%[clusterRangeTableIonic,ionq,~] = clusterDecompTablesIonic(x,y,z,m,position,extentZ,rangeTable,rangeElements,overlapY,overlapTable,zs);
%% Initialise vars
zprofile = cell(count,1); % per cluster store a cell of counts and positions
%% loop through all clusters of this {f} analysis and make *profile*

disp(strcat(num2str(c),'/',num2str(count))); % progress bar
cx = position(c,1); % cluster x,y,z
cy = position(c,2);
cz = position(c,3);
a = zs*extentZ(c); % scaled current cluster radius
p1 = z>(cz-a);
p2 = z<(cz+a);
p3 = x>(cx-a);
p4 = x<(cx+a);
p5 = y>(cy-a);
p6 = y<(cy+a);
p = p1&p2&p3&p4&p5&p6;
%% Save data
[r,n,e]=fileparts(rrngFileList{f});
savepos(x(p),y(p),z(p),m(p),strcat(n,'_c',num2str(c),'.pos'));
clear x y z m p nb p p1 p2 p3 p4 p5 p6
