function clusterIds = clusterIndexPart(posFileX,py,pz,clusterIndexedPosX,cy,cz,cm)
%clusterIds = clusterIndex(posFileX,py,pz,clusterIndexedPosX,cy,cz,cm)
% Using the .cluster.indexed.pos file this generates a list of clustered
% ions (numbered by cluster) and unclustered ions (clusterId = 0)
% A London Oct 2014
splitInto = 4;
n=length(posFileX);
parts = [round(n*(0:(splitInto-1))./splitInto)+1; round(n*(1:splitInto)./splitInto)];
Loc=zeros(1,n);
for i=1:splitInto
    % use is member to find clustered ions
    [~,Loc(parts(1,i):parts(2,i))]=ismemberNoNAN([posFileX(parts(1,i):parts(2,i))' py(parts(1,i):parts(2,i))' pz(parts(1,i):parts(2,i))'],[clusterIndexedPosX' cy' cz'],'rows');
end
clusterIds(Loc>0) = cm(Loc(Loc>0)); % logical indexing for speed
clusterIds=clusterIds';
% check it worked:
assert(length(clusterIds==1)>0,'No clusters detected with ID==1, is this a cluster.indexed.pos file?');
end