function clusterIds = clusterIndex2(posFileX,py,pz,clusterIndexedPosX,cy,cz,cm)
%clusterIds = clusterIndex(posFileX,py,pz,clusterIndexedPosX,cy,cz,cm)
% Using the .cluster.indexed.pos file this generates a list of clustered
% ions (numbered by cluster) and unclustered ions (clusterId = 0)
% A London Oct 2014

% pre-sorting of data
tic
[xcs,ix]=sort(clusterIndexedPosX);
% run ismember to get incidies of pos-data in sorted cluster data
[lx]=ismembc2(posFileX,xcs);
lx(lx>0) = ix(lx(lx>0)); % un-sort indicies
clear ix xcs
toc

[ycs,iy]=sort(cy);
[ly]=ismembc2(py,ycs);
ly(ly>0) = iy(ly(ly>0)); % un-sort indicies
clear iy ycs
toc

[zcs,iz]=sort(cz);
[lz]=ismembc2(pz,zcs);
lz(lz>0) = iz(lz(lz>0)); % un-sort indicies
clear iz zcs
toc
p=(lx>0 & ly>0 & lz>0);
clear lx ly lz
clusterIds(p)=cm(lz(p));

end