function clusterIds = clusterIndex(posFileX,py,pz,clusterIndexedPosX,cy,cz,cm)
%clusterIds = clusterIndex(posFileX,py,pz,clusterIndexedPosX,cy,cz,cm)
% Using the .cluster.indexed.pos file this generates a list of clustered
% ions (numbered by cluster) and unclustered ions (clusterId = 0)
% A London Oct 2014

% load pos
%[x,y,z,m,np]=readpos(posFile);
% load indexed pos
%[xc,yc,zc,mc,npc]=readpos(clusterIndexedPos);
% use is member to find clustered ions
%[~,Loc]=ismemberNoNAN([posFileX' py' pz'],[clusterIndexedPosX' cy' cz'],'rows');
[~,Loc]=ismember([posFileX' py' pz'],[clusterIndexedPosX' cy' cz'],'rows');
% Loc are the locations in cpos
% convert to cluster ids:
% clusterIds = zeros(size(pz));
% for i=1:length(Loc)
%     if Loc(i)
%         clusterIds(i)=cm(Loc(i));
%     end
% end
clusterIds = zeros(size(posFileX));
clusterIds(Loc>0) = cm(Loc(Loc>0)); % logical indexing for speed
clusterIds=clusterIds';
% check it worked:
assert(sum(clusterIds==1)>0,'No clusters detected with ID==1, is this a cluster.indexed.pos file?');

end