% simple script to the read the extentZ of many files
%[rangeFileList,posFileList,clusterFileList,volList,matList]=clusterFiles({'forPhil'});
[d,cols]=dataBase('mat=A1',1);
croot = 'C:\users\andy\apt\clusterAnalysis\';
clusterFileList = strcat(croot,d(:,strcmp(cols,'cf')));
matList = d(:,strcmp(cols,'mat'));
volList = d(:,strcmp(cols,'vol'));
numFiles = length(matList);
extents = cell(1,numFiles);
rz = cell(1,numFiles);
for f = 1:length(matList)
% read each file and store the extent:
[elements,countsDecomp,counts,position,ionType,radii,rz{f},extents{f},nTable,dmax,dbulk,derode,nmin,core,count] = clusterExtent(clusterFileList{f});
end
eList =vertcat(extents{:});
rzList=vertcat(rz{:});

% plot run specific size histograms
x = 0:0.25:20; % radius range
ylimits = [0 3E22]; % manual y-limits
ys = zeros(length(x),length(matList)); % place to store y results
n = length(matList);
for i=1:n
    subplot(ceil(n/floor(sqrt(n))), floor(sqrt(n)),i)
    y = hist(rz{i}*sqrt(5),x);
    y = y./(volList{i}*1E-27);
    ys(:,i) = y';
    bar(x,y,1); % width = 1
    xlim([x(1) x(end)]);
    ylim(ylimits);
    xlabel('Radius nm');
    ylabel('Particle No. Density m^{-3}');
end
% plot total particles/total volume:
figure
%yt = hist(rzList(rzList>2)*sqrt(5),x);
yt = hist(rzList*sqrt(5),x);
yt = yt./(sum(vertcat(volList{:}))*1E-27);
vt = sum(vertcat(volList{:}))*1E-27;
bar(x,yt,1);
xlabel('Radius nm');
ylabel('Particle No. Density m^{-3}');
title('Total Particle Number Density Size Distribution');