function [rangeFileList,posFileList,clusterFileList,volList,matList]=clusterFiles(opts)
%[rangeFileList,posFileList,clusterFileList,volList,matList]=clusterFiles(opts)
% Possible opts values: 'B2 unirrd' 'Irrd' 'Unirrd' 'UnirrdCr' 'UnirrdYTi' 'B3'
% plus others...
% Can provide multiple opts (cell array) which will concatonate the data
% takes a definition and returns the file list of the data files on C:
% Very specific script for A London     Sept 2013
% Added run volumes in nm3, and matList Oct 2013
% Might take 'factors' and compare all my data so that you could select a
% specific irradiation temperature or alloy or run volume etc. I have most
% of this data but not in a MATLAB friendly format, yet.
fileRoot = 'C:\Users\Andy\APT\';
clusterRoot = 'C:\Users\Andy\APT\clusterAnalysis\';
if length(opts)==1
    if strcmp(opts,'B2 unirrd')
        rangeList = {'17868','17870','17886','17890'};
        versionList = {1,1,1,2};
        folderList = {'','','',''};
        clusterFile = {'R14_17868-v01_OYYOTiO.csv', 'R14_17870-v01_OYYOTiO.csv','R14_17886-v01-clip2_OYYOTiOTiO2.csv','R14_17890-v02_YOFeO.csv'};
        volList = {129554.18, 384892.03, 611583.7, 96689.836};
        matList = {'B2u','B2u','B2u','B2u'};
    elseif strcmp(opts,'C2 unirrd')
        rangeList = {'17242'};
        versionList = {2};
        folderList = {''};
        clusterFile = {'R14_17242-v02-YYOTiO_80.csv'};
        volList = {199674.67};
        matList = {'C2u'};
    elseif strcmp(opts,'Irrd')
        % irradiated samples
        rangeList = {'17014', '17031', '17038', '17053', '17343', '17344', '16977', '17167', '17169', '17226', '16559', '16915', '16917', '16933', '17156', '17157', '17183', '16421', '16469', '16725', '16731', '16919'};
        versionList = {1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 3, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1}; % version of recon to use
        folderList = {'', '', '', '', '', '', '', '', '', '', ' C1', '', '', '', '', '', '', ' C2', ' C2', '', '', ''}; % additional post folder name guff
        clusterFile = {'R14_17014-v01_YTiOOYO.csv',...
            'R14_17031-v01_YYOOTiO.csv',...
            'R14_17038-v02-Proxy.csv',...
            'R14_17053-v01_YYOTiOO.csv',...
            'R14_17343-v02_YTiOYOO_oxcrop.csv',...
            'R14_17344-v01_OYTiOYO.csv',...
            'R14_16977-v01_YYOTiOO_80.csv',...
            'R14_17167-v01_YTiOYOO.csv',...
            'R14_17169-v01_OYYOTiO.csv',...
            'R14_17226-v01_YTiOYO.csv',...
            'R14_16559-v03_YO_80.csv',...
            'R14_16915-v02_YYOTiOO.csv',...
            'R14_16917-v01_YYOTiOO.csv',...
            'R14_16933-v01_YOYOTiOCrO.csv',...
            'R14_17156-v01_YYO.csv',...
            'R14_17157_YYOTiO.csv',...
            'R14_17183-v01_YOTiOCrO.csv',...
            'R14_16421-v01_YYOTiO_80.csv', ...
            'R14_16469-v01_YYOTiO_80.csv', ...
            'R14_16725-v02_TiOYO_80.csv',...
            'R14_16731-v01_YYO_80.csv',...
            'R14_16919-v01_YOTiOCrO.csv'};
        matList = {'B1','B1','B1','B3','B3','B3','B2','B2','B2','B2','C1','C1','C1','C1','C3','C3','C3','C2','C2','C2','C2','C2'};
        volList = {374102.16,128554,30234,495114.16,674130.3,254568.33,227544.86,254949.67,277045,252002,1227831.1,155259.83,180047.14,193430.5,376068.28,92998.34,425748.34,168136.33,167051.83,186637.33,333324.5,381476.66};
    elseif strcmp(opts,'Unirrd')
        rangeList = {'15868','15867','15734','15529','15065','15733','15783'};
        versionList = {1,2,2,2,4,1,2}; % version of recon to use
        folderList = {' Cr02',' Cr01',' Cr02','',' FeYTi_ex',' YTi04',' YTi04'}; % additional post folder name guff
        clusterFile = {'R14_15868-v01_YYOTiO_80.csv',...
            'R14_15867-v02_YYOTiO_80.csv',...
            'R14_15734-v02_YYOTiOO_80_08.csv',...
            'R14_15529-v02_OYTiOYO.csv',...
            'R14_15065-v04_YYOTiOO_08_80.csv',...
            'R14_15733-v01_YYOTiO_80.csv',...
            'R14_15783-v02_Y_YO_10_06.csv'};
        matList = {'Fe-14Cr ODS','Fe-14Cr ODS','Fe-14Cr ODS','Fe-14Cr ODS','Fe ODS','Fe ODS','Fe ODS'};
        volList = {227115,322436.34,1162448.1,1424060.1,895589.5,823288.3,394633};
    elseif strcmp(opts,'UnirrdYTi')
        rangeList = {'15065','15733','15783','15972','17868','17870','17886','17890'};
        versionList = {4,1,2,1,1,1,1,2}; % version of recon to use
        folderList = {' FeYTi_ex',' YTi04',' YTi04',' YTi03','','','',''}; % additional post folder name guff
        clusterFile = {'R14_15065-v04_YYOTiOO_08_80.csv',...
            'R14_15733-v01_YYOTiO_80.csv',...
            'R14_15783-v02_Y_YO_10_06.csv'...
            'R14_15972-v01_Y_YO_086_06.csv'...
            'R14_17868-v01_OYYOTiO.csv'...
            'R14_17870-v01_OYYOTiO.csv'...
            'R14_17886-v01_YYOTiOO-noH.csv'...
            'R14_17890-v02_YOFeO-noH.csv'};
        matList = {'Fe ODS','Fe ODS','Fe ODS','Fe ODS','Fe ODS','Fe ODS','Fe ODS','Fe ODS'};
        volList = {895589.5,823288.3,394633,35642,129554,384892,611584,96690};
    elseif strcmp(opts,'UnirrdCr')
        rangeList = {'15868','15867','15734','15529'};
        versionList = {1,2,2,2}; % version of recon to use
        folderList = {' Cr02',' Cr01',' Cr02',''}; % additional post folder name guff
        clusterFile = {'R14_15868-v01_YYOTiO_80.csv',...
            'R14_15867-v02_YYOTiO_80.csv',...
            'R14_15734-v02_YYOTiOO_80_08.csv',...
            'R14_15529-v02_OYTiOYO.csv'};
        matList = {'Fe-14Cr ODS','Fe-14Cr ODS','Fe-14Cr ODS','Fe-14Cr ODS'};
        volList = {227115,322436.34,1162448.1,1424060.1};
    elseif strcmp(opts,'UnirrdFull')
        rangeList = {'15868','15867','15734','15529','15065','15733','15783','17868','17870','17886','17890','17242'};
        versionList = {1,2,2,2,4,1,2,1,1,1,2,2}; % version of recon to use
        folderList = {' Cr02',' Cr01',' Cr02','',' FeYTi_ex',' YTi04',' YTi04','','','','',''}; % additional post folder name guff
        clusterFile = {'R14_15868-v01_YYOTiO_80.csv',...
            'R14_15867-v02_YYOTiO_80.csv',...
            'R14_15734-v02_YYOTiOO_80_08.csv',...
            'R14_15529-v02_OYTiOYO.csv',...
            'R14_15065-v04_YYOTiOO_08_80.csv',...
            'R14_15733-v01_YYOTiO_80.csv',...
            'R14_15783-v02_Y_YO_10_06.csv',...
            'R14_17868-v01_OYYOTiO.csv',...
            'R14_17870-v01_OYYOTiO.csv',...
            'R14_17886-v01-clip2_OYYOTiOTiO2.csv',...
            'R14_17890-v02_YOFeO.csv',...
            'R14_17242-v02-YYOTiO_80.csv'};
        matList = {'Fe-14Cr ODS','Fe-14Cr ODS','Fe-14Cr ODS','Fe-14Cr ODS','Fe ODS','Fe ODS','Fe ODS','Fe ODS','Fe ODS','Fe ODS','Fe ODS','Fe-14Cr ODS'};
        volList = {227115,322436.34,1162448.1,1424060.1,895589.5,823288.3,394633,129554.18, 384892.03, 611583.7, 96689.836,199674.67};
    elseif strcmp(opts,'B3')
        rangeList = {'17053','17343','17344'};
        versionList = {1, 2, 1};
        folderList = {'', '', ''};
        matList = {'B3','B3','B3'};
        volList = {495114.16,674130.3,254568.33};
        clusterFile = {'R14_17053-v01_YYOTiOO.csv', 'R14_17343-v02_YTiOYOO_oxcrop.csv' ,'R14_17344-v01_OYTiOYO.csv'};
    elseif strcmp(opts,'B3_2')
        rangeList = {'17985','17989','17996','18002'};
        versionList = {1, 1, 1, 1};
        folderList = {'', '', '', ''};
        matList = {'B3','B3','B3', 'B3'};
        volList = {111322.15, 137188.97, 478349.28, 479025.84};
        clusterFile = {'R14_17985-v01_YYOO2.csv','R14_17989-v01_YYOO2.csv', 'R14_17996-v01_OYYOTiO.csv' ,'R14_18002-v01_OYYOTiO.csv'};
    elseif strcmp(opts,'Yex')
        % extruded Fe-0.3Y2O3 material files
        rangeList = {'15576','15645','15975'};
        versionList = {2, 1, 1};
        folderList = {' YEx03', ' YEx04', ''};
        matList = {'Fe-0.3Y2O3','Fe-0.3Y2O3', 'Fe-0.3Y2O3'};
        volList = {662525.8,356169.66,639343.7};
        clusterFile = {'R14_15576-v02_YYOYO2OO2.csv','R14_15645-v01_YOYO2Y.csv','R14_15975-v01_YYO.csv'};
    elseif strcmp(opts,'Yex-empty1')
        % extruded Fe-0.3Y2O3 material files
        rangeList = {'15576','15633','15645','15975'};
        versionList = {2, 2, 1, 1};
        folderList = {' YEx03', ' YEx03', ' YEx04', ''};
        matList = {'Fe-0.3Y2O3','Fe-0.3Y2O3','Fe-0.3Y2O3', 'Fe-0.3Y2O3'};
        volList = {662525.8,233683.64,356169.66,639343.7};
        clusterFile = {'R14_15576-v02_YYOYO2OO2.csv','R14_15633-v02.csv','R14_15645-v01_YOYO2Y.csv','R14_15975-v01_YYO.csv'};
    elseif strcmp(opts,'C010')
        rangeList={'18357','18633'};
        versionList = {1,1};
        folderList = {'',''};
        volList = {786732,380078.84};
        clusterFile = {'R14_18357-v01_YYO.csv','R14_18633-v01.csv'};
        matList = {'C010','C010'};
	elseif strcmp(opts,'forPhil')
        rangeList={'15734','18220','16469'};
        versionList = {2,1,1};
        folderList = {' Cr02','b',' C2'};
        volList = {1162448,957393.2,167052};
        clusterFile = {'R14_15734-v02_YYOTiOO_80_08.csv','R14_18220-v01_YYOTiOCrO.csv','R14_16469-v01_YYOTiO_80.csv'};
        matList = {'Fe-Cr-Ti-Y','Fe-Cr-Ti-Y','Fe-Cr-Ti-Y'};
    else
        error(strcat('*** Unknown option:',opts',' ***'));
    end
    clusterFileList = strcat(clusterRoot,clusterFile);
    [rangeFileList, posFileList] = rpvLs(rangeList,versionList,folderList,fileRoot);
elseif length(opts)>1
    [rangeFileList,posFileList,clusterFileList,volList,matList]=clusterFiles(opts(1));
    for i = 2:length(opts)
        [rangeFileList2,posFileList2,clusterFileList2,volList2,matList2]=clusterFiles(opts(i));
        % concat lists
        rangeFileList = [rangeFileList rangeFileList2];
        posFileList = [posFileList; posFileList2];
        clusterFileList = [clusterFileList clusterFileList2];
        volList = [volList volList2];
        matList = [matList matList2];
    end
else
    disp('Please provide data selection options');
end
end