% Join two cluster analyses of the same data set. This will overwrite the
% existing cluster selection parameters! It joins the cluster.csv file,
% cluster.pos, indexed.cluster.pos and .cluster.indexed.rrng files and
% will write new ones with a -joined suffix
% A. London Oct 2014

numberOfAnalyses = 2; % how many files?
defaultPath = 'C:\users\andy\APT';
reopen = 0; % 0/1 repoen last used files (if loaded already)

% init vars
if ~reopen
    cf = cell(numberOfAnalyses,1);
    icpFile = cell(numberOfAnalyses,1);
    icpPath = cell(numberOfAnalyses,1);
end
roi = cell(numberOfAnalyses,1);
coreIons = cell(numberOfAnalyses,1);
dmax = cell(numberOfAnalyses,1);
clusterOrder = cell(numberOfAnalyses,1);
nmin = cell(numberOfAnalyses,1);
L = cell(numberOfAnalyses,1);
derosion = cell(numberOfAnalyses,1);
ccount = cell(numberOfAnalyses,1);
headers = cell(numberOfAnalyses,1);
m = cell(numberOfAnalyses,1); % matrix data
c = cell(numberOfAnalyses,1); % cluster data
cp = cell(numberOfAnalyses,1); % cluster.pos data
cip = cell(numberOfAnalyses,1); % cluster.indexed.pos data
rPS = 78; % column of first ion ranged percentage
for i=1:numberOfAnalyses
    if ~reopen
        [csvFile,csvPath] = uigetfile('.csv','Select cluster CSV file',defaultPath);
        cf{i} = [csvPath csvFile];
    end
   % read file
   fid = fopen(cf{i});
   if fid == -1
       error(['failed to open', cf{i}]);
   end
   % read cluster file header
   % ROI
   roi{i} = regexprep(fgets(fid),'(ROI,)|\n','','once');
   % Ion(s)
   t = regexprep(fgets(fid),'(Ion\(s\)\,)|\n','');
   coreIons{i} =regexp(t,'\,','split');
   %d-max (nm)
   t=regexp(fgets(fid),'(?<=^d-max.\(nm\),).*','match');
   dmax{i} = str2double(t);
   % Order (ions)
   t=regexp(fgets(fid),'(?<=^Order.\(ions\),).*','match');
   clusterOrder{i} = str2double(t);
   % N-min (ions)
   t=regexp(fgets(fid),'(?<=^N-min.\(ions\),).*','match');
   nmin{i} = str2double(t);
   % L (nm)
   t=regexp(fgets(fid),'(?<=^L.\(nm\),).*','match');
   L{i} = str2double(t);
   % d-erosion (nm)
   t=regexp(fgets(fid),'(?<=^d-erosion.\(nm\),).*','match');
   derosion{i} = str2double(t);
   % (blank)
   fgets(fid);
   % Cluster Count
   t=regexp(fgets(fid),'(?<=^Cluster.Count,).*','match');
   ccount{i} = str2double(t);
   % (blank)
   fgets(fid);
   headers{i} = fgets(fid);
   % Matrix data
   t = regexprep(fgets(fid),'(Matrix,)|\n','');
   m{i} = regexp(t,'\,','split');
   % Cluster data
   c{i} = cell(ccount{i},size(m{i},2));
   clusterID = 1;
   t = fgetl(fid);
   while clusterID <= ccount{i}
       t = regexprep(t,'(Cluster.\d+,)|\n','');
       c{i}(clusterID,:) = regexp(t,'\,','split');
       clusterID = clusterID + 1;
       t = fgetl(fid);
   end
   fclose(fid);
   if ~reopen
       disp('open cluster indexed rrng file');
       [icpFile{i},icpPath{i}] = uigetfile('.cluster.indexed.rrng','Open cluster indexed rrng file',defaultPath);
   end
   % Let's not bother reading the rrng file and just guess when we make a
   % new one.
%    disp(['assuming ' regexprep(icpFile,'.cluster.indexed.rrng','') '.cluster.indexed.pos file']);
%    rf = [icpPath icpFile];
%    % read file
%    fid = fopen(rf);
%    if fid == -1
%        error(['failed to open', rf]);
%    end
    % open cluster.pos and cluster.indexed.pos files
    [x,y,z,masses,~] = readpos([icpPath{i} regexprep(icpFile{i},'.cluster.indexed.rrng','.cluster.pos')]);
    cp{i} = [x' y' z' masses']; % .cluster.pos
    [x,y,z,masses,~] = readpos([icpPath{i} regexprep(icpFile{i},'.cluster.indexed.rrng','.cluster.indexed.pos')]);
    if i>1
        cip{i} = [x' y' z' (masses+sum(cell2mat(ccount(1:(i-1)))))']; % .cluster.indexed.pos with incremented masses
    else
        cip{i} = [x' y' z' masses']; % .cluster.indexed.pos
    end
    clear x y z masses
end
% Find 'Count' columns:
ccols = strfind(regexp(headers{1},',','split'),'Count');
ccols = ~cell2mat(cellfun(@isempty,ccols,'uni',0));
ccols = ccols(2:end); % remove first column
% '% Ranged' cols
rcols = strfind(regexp(headers{1},',','split'),'% Ranged');
rcols = ~cell2mat(cellfun(@isempty,rcols,'uni',0));
rcols = rcols(2:end); % remove first column
% '% Total' cols
tcols = strfind(regexp(headers{1},',','split'),'% Total');
tcols = ~cell2mat(cellfun(@isempty,tcols,'uni',0));
tcols = tcols(2:end); % remove first column

% sort data by total size
msize = zeros(1,numberOfAnalyses); % Matrix ranged ions
for i = 1:numberOfAnalyses
    msize(i) = str2double(m{i}(2));
end
[ai,ix]=sort(msize,'ascend'); % biggest last
m = m(ix);
c = c(ix);
cp = cp(ix);
cip = cip(ix);
% make new matrix data, mn
mn = m{1};

% number of ions
nions = sum(ccols);
% calc new matrix percentages
mn(rcols) = cellfun(@(x) sprintf('%6.4f%%',x), num2cell(100.*str2double(mn(ccols))./str2double(mn{2})) ,'uni',0);
mn(tcols) = cellfun(@(x) sprintf('%6.4f%%',x), num2cell(100.*str2double(mn(ccols))./str2double(mn{3})) ,'uni',0);

% make new cluster data
if 0 % users' choice?
    for i=1:numberOfAnalyses
        disp([num2cell(i) cf(i)]);
    end
    i = input('Reuse which settings for the header?');
    if ~isnumeric(i)
        i = 1; % check input
        disp('Using choice 1');
    elseif i>numberOfAnalyses || i<1
        i = 1;
        disp('Using choice 1');
    end
else
    i = ix(1);
end
% header
newcsv(1,1:2) = ['ROI' roi(i)];
newcsv(2,1:(1+size(coreIons{i},2))) = ['Ion(s)' coreIons{i}];
newcsv(3,1:2) = ['d-max (nm)' dmax(i)];
newcsv(4,1:2) = ['Order (ions)' clusterOrder(i)];
newcsv(5,1:2) = ['N-min (ions)' nmin(i)];
newcsv(6,1:2) = ['L (nm)' L(i)];
newcsv(7,1:2) = ['d-erosion (nm)' derosion(i)];
totalClusters = sum(cell2mat(ccount));
newcsv(9,1:2) = {'Cluster Count',totalClusters};
h = regexp(headers{i},',','split');
newcsv(11,1:size(h,2)) = regexprep(h,'\n','');
% matrix
newcsv(12,1:(size(h,2))) = ['Matrix' mn];
% cluster names
newcsv(13:(totalClusters+12),1) = cellfun(@(x) sprintf('Cluster %d',x),num2cell(1:totalClusters)','uni',0);
% cluster data
newcsv(13:(totalClusters+12),2:(size(h,2))) = vertcat(c{:});
% write new cluster data file
disp(['Writing: ' regexprep(cf{i},'\.csv','-joined.csv')]);
cell2csv(regexprep(cf{i},'\.csv','-joined.csv'),newcsv);
clear newcsv c

% write new .cluster.indexed.pos file
a = vertcat(cip{:});
savepos(a(:,1),a(:,2),a(:,3),a(:,4),[icpPath{i} regexprep(icpFile{i},'.cluster.indexed.rrng','-joined.cluster.indexed.pos')]);
clear a cip
% write new .cluster.pos file
a = vertcat(cp{:});
savepos(a(:,1),a(:,2),a(:,3),a(:,4),[icpPath{i} regexprep(icpFile{i},'.cluster.indexed.rrng','-joined.cluster.pos')]);
clear a cp
% write new cluster.indexed.rrng file
writeIndexRrng([icpPath{i} regexprep(icpFile{i},'.cluster','-joined.cluster')],totalClusters);