% Fe/Cr ratio script
%% Get cluster files
opts = {'Unirrd'};
[rangeFileList,posFileList,clusterFileList,~,matList]=clusterFiles(opts);
posRoot = 'C:\Users\Andy\APT\';
% select only Fe-14Cr ODS data sets
cl = strcmp('Fe-14Cr ODS',matList);
rangeFileList = rangeFileList(cl);
posFileList = posFileList(cl);
clusterFileList = clusterFileList(cl);
% results data, elemental Fe, Cr, Ionic Fe, Cr, Size Rg, Rz, extent
results = cell(1,length(clusterFileList));
%% Read cluster files in tern
for c=1:length(clusterFileList)
    [elements,countsDecomp,counts,position,ionType,radii,rz,extentZ,nTable,dmax,dbulk,derode,nmin,core,count] = clusterExtent(clusterFileList{c});
    % find the Fe and Cr count columns
    results{c}(:,1) = countsDecomp(:,strcmp(elements,'Fe'));
    results{c}(:,2) = countsDecomp(:,strcmp(elements,'Cr'));
    results{c}(:,3) = counts(:,strcmp(ionType,'Fe'));
    results{c}(:,4) = counts(:,strcmp(ionType,'Cr'));
    results{c}(:,5) = radii;
    results{c}(:,6) = rz;
    results{c}(:,7) = extentZ;
end
%% Format data
resultsLong = zeros(sum(cellfun(@(x) size(x,1),results)),7);
index = 1;
for i = 1:length(clusterFileList)
    count = length(results{i}(:,1));
    resultsLong(index:(index+count-1),:) = results{i};
    index = index + count;
end
%% Determine Fe/Cr ratio
Fe = resultsLong(:,1);
Cr = resultsLong(:,2);
Size = resultsLong(:,5);
Fe2 = resultsLong(:,3);
Cr2 = resultsLong(:,4);
Rz = resultsLong(:,6);
Ez = resultsLong(:,7);
%% Plot results
scatter(Size,Cr./Fe)
% plot with smoothed data
%scatter(Ez,(Cr./Fe));hold all;scatter(Ez,(Cr2./Fe2));scatter(Ez,smooth(Ez,Cr./Fe,0.25,'rloess'));scatter(Ez,smooth(Ez,Cr2./Fe2,0.25,'rloess'));hold off;legend('Decomp','Elemental','FitD','FitE')
% plot using histogram average and errors
r = 0:1:10;
hy=NaN;hx=NaN;he=NaN;
for i=2:length(r)
    a = Cr(Ez>r(i-1) & Ez<=r(i));
    b = Fe(Ez>r(i-1) & Ez<=r(i));
    hh = a./(b+a);
    hy(i) = mean(hh);
    he(i) = std(hh);
    hx(i) = (r(i-1)+r(i))/2;
end
scatter(Ez,Cr./(Fe+Cr),'r.');hold all;errorbar(hx,hy,he);hold off