% cluster dpa script: using the initial depth and fitted dpa-depth curves
% to give a list of the estimated dpa per cluster for a list of data sets
% and cluster settings files (loaded in this case, using dataBase).
% A London Dec 2014

[d,cols] = dataBase('run>0',1); % load only usable data
clusterFiles = strcat('C:\users\andy\APT\clusterAnalysis\', d(:,strcmp('cf',cols)));
irrdDpa1 = (d(:,strcmp('irrdDpa1',cols))); % peak damage of 1st irrd treatment
ionE = d(:,strcmp('ionE',cols));
mat = d(:,strcmp('matCode',cols));
energies = {'5MeV','1760keV'};  % otherwise 0
energyFiles = {'dpa5MeV.mat','dpa1760keV.mat'}; % depth-dpa files
peakDpa = cell(size(energyFiles));
dpas = cell(size(d(:,1)));
code = cell(size(d(:,1)));
run = cell(size(d(:,1)));
yti = cell(size(d(:,1)));
r = cell(size(d(:,1)));
for i=1:size(d,1)
    disp([num2str(i) '/' num2str(size(d,1))]);
    e = strcmp(ionE{i},energies);
    if sum(e)
        load(energyFiles{e}); % load dpa & x
        dpaScale = max(dpa)/irrdDpa1{i}; % peak damage
        d0 = d{i,strcmp('depth',cols)};
        [elements,countsDecomp,~,p,~,~,rz,~,~,~,~,~,~,~,count] = clusterExtent(clusterFiles{i}); % p=cluster coords
        dpas{i} = interp1(x,dpa/dpaScale,p(:,3)+d0,'linear',0);
        code{i} = cell(count,1);
        code{i}(:) = mat(i);
        run{i} = cell(count,1);
        run{i}(:) = d(i,strcmp('run',cols));
        r{i} = rz*sqrt(5);
        yti{i} = countsDecomp(:,strcmp('Y',elements))./countsDecomp(:,strcmp('Ti',elements));
    else
        [elements,countsDecomp,~,p,~,~,rz,~,~,~,~,~,~,~,count] = clusterExtent(clusterFiles{i}); % p=cluster coords
        dpas{i} = zeros(count,1);
        code{i} = cell(count,1);
        code{i}(:) = mat(i);
        run{i} = cell(count,1);
        run{i}(:) = d(i,strcmp('run',cols));
        r{i} = rz*sqrt(5);
        yti{i} = countsDecomp(:,strcmp('Y',elements))./countsDecomp(:,strcmp('Ti',elements));
    end
end
disp('saving export file rDPA.csv');
export = [{'run' 'mat', 'dpa', 'r' 'yti'}; vertcat(run{:}) vertcat(code{:}) num2cell(vertcat(dpas{:})) num2cell(vertcat(r{:})) num2cell(vertcat(yti{:}))];
cell2csv('rDPA.csv',export)
beep