% clusterDetails script to read the parameters used for many cluster
% analyses (created by IVAS) using clusterDataReaderDetails function
% A London Dec 2013

% opts = {'Irrd'};
% [~,~,clusterFileList,~,~]=clusterFiles(opts);
cfRoot = 'C:\Users\Andy\APT\clusterAnalysis\';
[d,cols]=dataBase('run>0',1); % load all usable data sets
clusterFileList = strcat(cfRoot,d(:,strcmp('cf',cols)));

n = length(clusterFileList);
% initialise results
radii = cell(n,1);
extent = cell(n,1);
solute = cell(n,1);
totals = cell(n,1);
sions = {'Y','Ti','O'};
dmax = cell(n,1);
dbulk= cell(n,1);
derode= cell(n,1);
nmin= cell(n,1);
core= cell(n,1);
count= cell(n,1);
% loop through all cluster files
for f=1:n
   [elements,countsDecomp,counts,position,ionType,radii{f},rg,extent{f},nTable,dmax{f},dbulk{f},derode{f},nmin{f},core{f},count{f}] = clusterExtent2(clusterFileList{f});
   solute{f} = num2cell(sum(countsDecomp(:,cell2mat(cellfun(@(x) find(strcmp(x,elements)),sions,'uni',0))),2)); 
   totals{f} = num2cell(sum(countsDecomp,2));
end
count = cellfun(@(x) size(x,1),radii,'uni',0);
dpa = d(:,strcmp('dpa',cols));
header = {'run','matCode','mat','irrdT1','irrdDpa1','irrdT2','irrdDpa2'};
data = d(:,cell2mat(cellfun(@(x) find(strcmp(x,cols)),header,'uni',0)));
a=cell(size(data,1),1);
for i = 1:size(data,1)
   a{i} = repmat(data(i,:),count{i},1); 
end
tcount = sum(cell2mat(count));
export = [header {'x','y','z','radius','dpa','solute','ions'}; ...
    vertcat(a{:}) num2cell(vertcat(radii{:})*sqrt(5)) repmat({'Gyration'},tcount,1) num2cell(vertcat(dpa{:})) vertcat(solute{:}) vertcat(totals{:});... 
    vertcat(a{:}) num2cell(vertcat(extent{:})) repmat({'Extent'},tcount,1) num2cell(vertcat(dpa{:})) vertcat(solute{:}) vertcat(totals{:})];
core2 = cell(n,1);
for i = 1:length(core)
    a=cellfun(@(x) [x,', '],sort(core{i}),'uni',0);
    core2{i} = [a{:}];
    core2{i} = core2{i}(1:end-2); % remove trailing ", "
end
export2 = [{'run','mat','matCode','dmax','dbulk','derode','nmin','core','count'};...
    d(:,strcmp('run',cols)) d(:,strcmp('mat',cols)) d(:,strcmp('matCode',cols)) dmax dbulk derode nmin core2 count];
%cell2csv('clusterRef.csv',export2) % -> used in Appendix of thesis